<?php

/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */

namespace Lifeline\Classes;

use Lifeline\Classes\PageLoader;
use Lifeline\Classes\Enqueue;
use Lifeline\Classes\Ajax;
use Lifeline\Classes\WoocommerceCustomize;
use Lifeline\Classes\Breadcrumb;

class Setup {

	static function init() {
		add_filter( 'the_content', 'lifeline_color', 1000 );
		load_theme_textdomain( 'lifeline', get_template_directory() . '/languages' );

		self::registerMenus();
		self::imageSizes();
		self::supports();
		self::tinyMceButton();

		if ( ! isset( $content_width ) ) {
			$content_width = 900;
		}
	}

	static function other_init() {
		add_action( 'widgets_init', array( __CLASS__, 'sidebars' ) );

		if ( ! is_admin() ) {
			PageLoader::boot();
		}

		// self::demo_import();

		Enqueue::setup();
		( new Ajax )->actions();

		if ( function_exists( 'WC' ) ) {
			WoocommerceCustomize::init();
		}

		self::theme_update_check();

		Breadcrumb::boot();
	}

	static function sidebars() {
		$default_sidebar = apply_filters(
			// phpcs:ignore WordPress
			'lifeline/sidebar/main',
			array(
				'name'          => esc_html__( 'Lifeline: Main Sidebar', 'lifeline-plugin' ),
				'id'            => 'sidebar-1',
				'description'   => esc_html__( 'Widgets in this area will be shown on all posts and pages.', 'lifeline-plugin' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s widget-box2 mt-50 w-100">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);
		if ( ! empty( $default_sidebar ) ) {
			register_sidebar( $default_sidebar );
		}

		$footer_sidebar = apply_filters(
			// phpcs:ignore WordPress
			'lifeline/sidebar/footer',
			array( 
				'name'          => esc_html__( 'Lifeline: Footer Sidebar', 'lifeline-plugin' ),
				'id'            => 'footer',
				'description'   => esc_html__( 'Widgets in this area will be shown on all posts and pages.', 'lifeline-plugin' ),
				'before_widget' => '<div class="col-md-3 col-sm-6 col-lg-3"><div id="%1$s" class="widget mt-50 %2$s widget-box">',
				'after_widget'  => '</div></div>',
				'before_title'  => '<h3 class="text-white">',
				'after_title'   => '</h3>',
			)
		);
		if ( ! empty( $footer_sidebar ) ) {
			register_sidebar( $footer_sidebar );
		}
	}

	static function registerMenus() { // phpcs:ignore WordPress
		$menu_list = apply_filters(
			// phpcs:ignore WordPress
			'lifeline/menus',
			array(
				'main_menu' => esc_html__( 'Main Menu', 'lifeline' ),
				'footer'    => esc_html__( 'Footer Menu', 'lifeline' ),
			)
		);

		register_nav_menus( $menu_list );
	}

	static function imageSizes() { // phpcs:ignore WordPress
		$sizes = array(
			'lifeline_570x421'  => array( 570, 421, true ),
			'lifeline_270x207'  => array( 270, 207, true ),
			'lifeline_350x460'  => array( 350, 460, true ),
			'lifeline_140x180'  => array( 140, 180, true ),
			'lifeline_350x370'  => array( 350, 370, true ),
			'lifeline_80x80'  => array( 80, 80, true ),
			'lifeline_955x530'  => array( 955, 530, true ),
			'lifeline_870x410'  => array( 870, 410, true ),
			'lifeline_290x290'  => array( 290, 290, true ),
			'lifeline_350x350'  => array( 350, 350, true ),
			'lifeline_320x310'  => array( 320, 310, true ),
			'lifeline_870x470'  => array( 870, 470, true ),
			'lifeline_350x350'  => array( 350, 350, true ),
			'lifeline_350x280'  => array( 350, 280, true ),
			'lifeline_448x557'  => array( 448, 557, true ),
			'lifeline_110x110'   => array( 110, 110, true ),
		);
		// phpcs:ignore WordPress
		$sizes = apply_filters( 'lifeline/image/sizes', $sizes );

		foreach ( $sizes as $name => $value ) {
			add_image_size( $name, $value[0], $value[1], lifeline_get( $value, 2, false ) );
		}
	}

	static function supports() {
		add_theme_support( 'widgets' );
		$defaults = array(
			'height'      => null,
			'width'       => null,
			'flex-height' => true,
			'flex-width'  => true,
			'header-text' => array( 'site-title', 'site-description' ),
		);
		add_theme_support( 'custom-logo', $defaults );

		$post_format = apply_filters(
			// phpcs:ignore WordPress
			'lifeline/post/format',
			array(
				'standard',
				'video',
				'gallery',
				'audio',
			)
		);
		add_theme_support( 'post-formats', $post_format );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'editor-styles' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'align-left' );
		add_theme_support( 'post-thumbnails' );
		$args = array(
			'default-color' => '0000ff',
		);
		add_theme_support( 'custom-background', $args );
	}

	static function tinyMceButton() { // phpcs:ignore WordPress
		add_filter( 'tiny_mce_before_init', array( __CLASS__, 'tinyMceFontsizeFormats' ) );
		add_filter( 'mce_buttons', array( __CLASS__, 'mceButtons1' ) );
		add_filter( 'mce_buttons_2', array( __CLASS__, 'mceButtons2' ) );
	}

	static function mceButtons1( $buttons ) { // phpcs:ignore WordPress
		$buttons[0]  = 'formatselect';
		$buttons[1]  = 'bold';
		$buttons[2]  = 'italic';
		$buttons[3]  = 'underline';
		$buttons[4]  = 'bullist';
		$buttons[5]  = 'numlist';
		$buttons[6]  = 'blockquote';
		$buttons[7]  = 'alignleft';
		$buttons[8]  = 'aligncenter';
		$buttons[9]  = 'alignright';
		$buttons[10] = 'alignjustify';
		$buttons[11] = 'link';
		$buttons[12] = 'wp_more';
		$buttons[13] = 'spellchecker';
		$buttons[14] = 'dfw';
		$buttons[15] = 'wp_adv';

		return $buttons;
	}

	static function mceButtons2( $buttons ) { // phpcs:ignore WordPress
		array_unshift( $buttons, 'superscript' );
		array_unshift( $buttons, 'subscript' );
		array_unshift( $buttons, 'fontselect' );
		array_unshift( $buttons, 'fontsizeselect' );

		return $buttons;
	}

	static function tinyMceFontsizeFormats( $settings ) { // phpcs:ignore WordPress
		$settings['fontsize_formats'] = implode( 'px ', range( 5, 80 ) ) . 'px';

		return $settings;
	}

	/**
	 * demo_import
	 *
	 * @return void
	 */
	// static function demo_import() {
	// 	require_once get_theme_file_path( 'webinane_import/class-merlin.php' );
	// 	require_once get_theme_file_path( 'webinane_import/merlin-config.php' );
	// 	require_once get_theme_file_path( 'webinane_import/merlin-filters.php' );
	// }

	static function theme_update_check() {
		$themes = array(
			'lifeline-corona-virus',
			'lifeline-global-warming',
			'lifeline-population',
		);
		foreach ( $themes as $theme ) {
			new \Lifeline\Libraries\ThemeUpdateChecker( $theme, get_template_directory_uri() . "/assets/json/{$theme}.json" );
		}
	}
}
