<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */
namespace Lifeline\Classes;

class Enqueue {

	/**
	 * List of global_scripts to enqueue
	 * @var $scripts
	 */
	protected static $global_scripts = array(
		'lifeline-bootstrap'           => 'assets/js/bootstrap.min.js',
		'slick'               => 'assets/js/slick.min.js',
		'slick-init'          => 'assets/js/slick-init.js',
		'crypt'               => 'assets/js/crypt.js',
		'encryption'          => 'assets/js/encryption.js',
		'sticky'              => 'assets/js/jquery.sticky.js',
		'lifeline-form'      => 'assets/js/lifeline-form.js',
		'fancybox'            => 'assets/js/jquery.fancybox.min.js',
		'downCount'           => 'assets/js/jquery.downCount.js',
		'counterup'           => 'assets/js/jquery.counterup.min.js',
		'isotope'             => 'assets/js/isotope.min.js',
		'isotope-init'        => 'assets/js/isotope-int.js',
		'scroll-up-bar'       => 'assets/js/scroll-up-bar.min.js',
		'barfiller'           => 'assets/js/jquery.barfiller.js',
		'nice-select'         => 'assets/js/jquery.nice-select.min.js',
		'owl-carousel'        => 'assets/js/owl.carousel.min.js',
		// 'select2'             => 'assets/js/select2.min.js',
		'owl-init'            => 'assets/js/owl-init.js',
		'totap'               => 'assets/js/totop.min.js',
		'bootstrap-touchspin' => 'assets/js/bootstrap-touchspin.min.js',
		'mCustomScrollbar'    => 'assets/js/jquery.mCustomScrollbar.min.js',
		'flickr'              => 'assets/js/jflickrfeed.min.js',
		'lifeline-common'    => 'assets/js/lifeline-common.js',
		'wow'                 => 'assets/js/wow.min.js',
	);

	/**
	 * List of scripts to enqueue
	 * @var $scripts
	 */
	protected static $scripts = array(
		'lifeline-script' => 'assets/js/lifeline-script.js',
	);

	/**
	 * List of styles to enqueue.
	 * @var $styles
	 */
	protected static $styles = array(
		'lifeline-bootstrap'   => 'assets/css/bootstrap.min.css',
		'animate'              => 'assets/css/animate.min.css',
		'slick'                => 'assets/css/slick.min.css',
		'font-awesome-css'         => 'assets/css/all.min.css',
		'compiler'             => 'assets/css/compiler.css',
		'fancybox'             => 'assets/css/jquery.fancybox.min.css',
		'owl-carousel'         => 'assets/css/owl.carousel.min.css',
		'nice-select'          => 'assets/css/nice-select.css',
		// 'select2'             => 'assets/js/select2.min.css',
		'mCustomScrollbar'     => 'assets/css/jquery.mCustomScrollbar.min.css',
		'loaders'              => 'assets/css/loaders.min.css',
		'lifeline-common'     => 'assets/css/common.min.css',
		'lifeline-main'       => 'assets/css/style.css',
		'lifeline-responsive' => 'assets/css/responsive.css',
		'lifeline-color' => 'assets/css/color.css',
		'lifeline-color2' => 'assets/css/color2.css',
	);

	/**
	 * List of scripts to enqueue by default.
	 * @var $default_scripts
	 */
	protected static $default_scripts = array(
		'jquery',
		'wow',
		'lifeline-bootstrap',
		'barfiller',
		'nice-select',
		'lifeline-common',
		'lifeline-script',
	);

	/**
	 * List of styles to eqnueue by default.
	 * @var $default_styles
	 */
	protected static $default_styles = array(
		'lifeline-bootstrap',
		'font-awesome-css',
		'loaders',

	);

	/**
	 * Set the theme version.
	 * @var $version
	 */
	protected static $version = '';

	/**
	 * Set theme version.
	 * @return [type] [description]
	 */
	static function version() {
		//$theme         = wp_get_theme();
		//self::$version = $theme->Version; // phpcs:ignore WordPress
		self::$version = time();
	}

	/**
	 * Finally run the setup.
	 * @return [type] [description]
	 */
	static function setup() {
		self::version();
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue' ), 2000 );
	}

	/**
	 * Hooked up with enqueue.
	 * @return [type] [description]
	 */
	static function enqueue() {
		self::scripts();
		self::styles();
		//self::fonts();
	}

	/**
	 * Register and Enqueue scripts.
	 *
	 * @return [type] [description]
	 */
	static function scripts() {
		// phpcs:ignore WordPress
		$scripts = apply_filters( 'lifeline/scripts/global', self::$global_scripts );
		$scripts = array_merge( $scripts, apply_filters( 'lifeline/scripts', self::$scripts ) );

		foreach ( $scripts as $handler => $file ) {
			wp_register_script(
				$handler,
				self::url( $file ),
				array(),
				self::$version,
				true
			);
		}

		wp_enqueue_script( self::$default_scripts );

		wp_enqueue_script( 'google-recaptcha', 'https://www.google.com/recaptcha/api.js', '', self::$version, true );

		if ( function_exists( 'is_cart' ) && is_cart() || function_exists( 'is_product' ) && is_product() ) {
			wp_enqueue_script( 'bootstrap-touchspin' );
			$script = 'jQuery(document).ready(function($){
				$(".quantity > input").TouchSpin({
					min: 0,
					max: 100
				});
			})';
			wp_add_inline_script( 'bootstrap-touchspin', $script );
		}

		if ( is_single() ) {
			wp_enqueue_script( 'comment-reply' );
		}

		$data = array(
			'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
			'nonce'   => wp_create_nonce( LIFELINE_NONCE ),
		);

		if ( function_exists( 'wpcm_get_settings' ) ) {
			$donation_settings     = wpcm_get_settings();
			$data['header_button'] = array(
				'color'          => $donation_settings->get( 'menu_donation_button_font_color' ),
				'bg_color'       => $donation_settings->get( 'menu_donation_button_color' ),
				'color_hover'    => $donation_settings->get( 'menu_donation_button_text_hover_color' ),
				'bg_color_hover' => $donation_settings->get( 'menu_donation_button_hover_color' ),
			);
		}

		wp_localize_script( 'lifeline-bootstrap', 'lifeline_data', $data );
	}

	/**
	 * Register and enqueue Styles.
	 * @return [type] [description]
	 */
	static function styles() {
		if ( is_rtl() ) {
			self::$styles['lifelin2-rtl'] = 'assets/css/rtl.css';
		}
		// phpcs:ignore WordPress
		$styles                 = apply_filters( 'lifeline/styles', self::$styles );
		$styles['google-fonts'] = self::fonts();
		// echo '<pre>';
		// print_r( $file );
		foreach ( $styles as $handler => $file ) {
			wp_enqueue_style(
				$handler,
				self::url( $file ),
				array(),
				self::$version
			);
		}

		$theme_primary_color = lifeline_get( lifeline()->options(), 'theme_color_scheme', '#00b3ac' );
		$theme_primary_color2 = lifeline_get( lifeline()->options(), 'theme_color_scheme2', '#004d4a' );
		$css_veriable = ":root { 
			--theme-primary-color:  " . $theme_primary_color . "; 
			--theme-primary-color2:  " . $theme_primary_color2 . "; 
		}";

		wp_add_inline_style( 'lifeline-responsive', $css_veriable );
	}

	/**
	 * Generate assets URL from the path.
	 *
	 * @param  [type] $url [description]
	 * @return [type]      [description]
	 */
	static function url( $url = '' ) {
		if ( strstr( $url, 'http://' ) || strstr( $url, 'https://' ) ) {
			return $url;
		}
		$path = get_theme_file_uri( $url );
		// echo '<pre>';
		// print_r( $path );
		return $path;
	}

	/**
	 * List of Fonts to enqueue
	 * @var $fonts
	 */
	protected static function fonts() {
		$h1        = lifeline()->options( 'h1_typography.font-family' );
		$fonts_url = '';

		$font_families = array(
			'Quick-sand' =>  'Quicksand:00,400,500,600,700&display=swap',
			// 'Roboto' => 'Roboto:400,500,600,700&display=swap',
			// 'Poppins'    => 'Poppins:500,600,700,700i,800,900&display=swap',
		);
		// phpcs:ignore WordPress
		$font_families = apply_filters( 'lifeline/fonts', $font_families );

		if ( lifeline()->options( 'use_custom_heading_style_h1' ) ) {
			$font_families = self::generate_font_url( 'h1_typography', $font_families );
		}
		if ( lifeline()->options( 'use_custom_heading_style_h2' ) ) {
			$font_families = self::generate_font_url( 'h2_typography', $font_families );
		}
		if ( lifeline()->options( 'use_custom_heading_style_h3' ) ) {
			$font_families = self::generate_font_url( 'h3_typography', $font_families );
		}
		if ( lifeline()->options( 'use_custom_heading_style_h4' ) ) {
			$font_families = self::generate_font_url( 'h4_typography', $font_families );
		}
		if ( lifeline()->options( 'use_custom_heading_style_h5' ) ) {
			$font_families = self::generate_font_url( 'h5_typography', $font_families );
		}
		if ( lifeline()->options( 'use_custom_heading_style_h6' ) ) {
			$font_families = self::generate_font_url( 'h6_typography', $font_families );
		}
		if ( lifeline()->options( 'body_custom_fonts' ) ) {
			$font_families = self::generate_font_url( 'body_typography', $font_families );
		}

		//$font_families[lifeline()->options('h1_typography')['font-family']] = 'Roboto:400,500,700,700i&display=swap';
		// phpcs:ignore WordPress
		$font_families = apply_filters( 'Lifeline/includes/classes/header_enqueue/font_families', $font_families );
		$query_args    = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$protocol  = is_ssl() ? 'https' : 'http';
		$fonts_url = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css' );

		return esc_url_raw( $fonts_url );
	}

	static function generate_font_url( $key, $var ) {
		$font = lifeline()->options( $key . '.font-family' );
		$fw   = lifeline()->options( $key . '.font-weight' );

		$var[ $font ] = $font . ':400,500,600,700,700i&display=swap';

		return $var;
	}
}
