<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.6
 */
namespace Lifeline\Classes;

class Breadcrumb {
	private static $defaults;
	public static function boot() {
		add_action( 'lifeline/breadcrumb', array( __CLASS__, 'init' ), 10, 1 );
	}

	public static function init( $args = array() ) {

		self::is_front();


		self::$defaults = array(
			'seperator'       => lifeline_get( lifeline()->options(), 'breadcrumbs_sep' ),
			'seperator_class' => 'seperato',
			'seperator_id'    => 'seperator',
			'home_title'      => esc_html__( 'Home', 'lifeline' ),
			'wrapper'         => 'nav',
			'wrapper_id'      => 'breadcrumb-wrapper',
			'wrapper_class'   => 'breadcrumb-wrapper',
			'parent'          => 'ol',
			'parent_id'       => 'breadcrumb-parent',
			'parent_class'    => 'breadcrumb-parent breadcrumb p-0 mb-0',
			'child'           => 'li',
			'child_id'        => 'breadcrumb-child',
			'child_class'     => 'breadcrumb-child breadcrumb-item commen-text position-relative',
		);

		self::$defaults = wp_parse_args( $args, self::$defaults );
		?>
		<<?php echo esc_attr( self::$defaults['wrapper'] ); ?> class="<?php echo esc_attr( self::$defaults['wrapper_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['wrapper_id'] ); ?>">
			<<?php echo esc_attr( self::$defaults['parent'] ); ?> class="<?php echo esc_attr( self::$defaults['parent_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['parent_id'] ); ?>">
				<?php self::home_link(); ?>
				<?php self::blog(); ?>
				<?php self::single(); ?>
				<?php self::archive(); ?>
				<?php self::page(); ?>
				<?php self::search(); ?>
				<?php self::error_404(); ?>
			</<?php echo esc_attr( self::$defaults['parent'] ); ?>>
		</<?php echo esc_attr( self::$defaults['wrapper'] ); ?>>
		<?php

	}

	public static function is_front() {
		// Check if is front/home page, return
		if ( is_front_page() ) {
			return;
		}
	}

	public static function sep() {
		?>
		<<?php echo esc_attr( self::$defaults['child'] ); ?> class="<?php echo esc_attr( self::$defaults['seperator_class'] . ' ' . self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['seperator_id'] ); ?>">
			<?php echo sprintf( '%s', self::$defaults['seperator'] ); ?>
		</<?php echo esc_attr( self::$defaults['child'] ); ?>>
		<?php
	}

	public static function home_link() {
		?>
		<<?php echo esc_attr( self::$defaults['child'] ); ?> class="<?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html( self::$defaults['home_title'] ); ?></a>
		</<?php echo esc_attr( self::$defaults['child'] ); ?>>
		<?php
		self::sep();
	}

	public static function blog() {
		global $wp_query;
		if ( ! $wp_query->is_posts_page ) {
			return;
		}
		?>
		<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
			<span><?php echo $wp_query->get_queried_object()->post_title; ?></span>
		</<?php echo esc_attr( self::$defaults['child'] ); ?>>
		<?php
	}

	public static function single() {

		if ( is_single() ) {

			global $post;

			// Get posts type
			$post_type = $post->post_type;

			// If post type is not post
			if ( 'post' !== $post_type ) {

				$post_type_object = get_post_type_object( $post_type );
				$post_type_link   = get_post_type_archive_link( $post_type );

				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="<?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<a href="<?php echo esc_url( $post_type_link ); ?>"><?php echo esc_html( $post_type_object->labels->name ); ?></a>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php
				self::sep();

			}

			// Get categories
			$category = get_the_category( $post->ID );

			// If category not empty
			if ( ! empty( $category ) ) {

				// Arrange category parent to child
				$category_values     = array_values( $category );
				$get_last_category   = end( $category_values );
				$get_parent_category = rtrim( get_category_parents( $get_last_category->term_id, true, ',' ), ',' );
				$cat_parent          = explode( ',', $get_parent_category );

				// Store category in $display_category
				$display_category = '';
				foreach ( $cat_parent as $p ) {
					ob_start();
					?>
						<<?php echo esc_attr( self::$defaults['child'] ); ?> class="item-cat <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
							<?php echo sprintf( '%s', $p ); ?>
						</<?php echo esc_attr( self::$defaults['child'] ); ?>>
					<?php
					self::sep();
					$display_category .= ob_get_clean();
				}
			}

			// Check if the post is in a category
			if ( ! empty( $get_last_category ) ) {

				echo sprintf( '%s', $display_category );
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php the_title(); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			} else {
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php the_title(); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php
			}
		}
	}

	public static function archive() {
		if ( is_archive() ) {

			if ( is_tax() ) {
				// Get posts type
				$post_type = get_post_type();

				// If post type is not post
				if ( $post_type != 'post' ) {

					$post_type_object = get_post_type_object( $post_type );
					$post_type_link   = get_post_type_archive_link( $post_type );
					?>
					<<?php echo esc_attr( self::$defaults['child'] ); ?> class="item-cat item-custom-post-type-<?php echo esc_attr( $post_type ); ?> <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
						<a href="<?php echo esc_url( $post_type_link ); ?>"><?php echo esc_html( $post_type_object->labels->name ); ?></a>
					</<?php echo esc_attr( self::$defaults['child'] ); ?>>
					<?php
					self::sep();

				}

				$custom_tax_name = get_queried_object()->name;
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( $custom_tax_name ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			} elseif ( is_category() ) {

				$parent = get_queried_object()->category_parent;

				if ( $parent !== 0 ) {

					$parent_category = get_category( $parent );
					$category_link   = get_category_link( $parent );
					?>
					<<?php echo esc_attr( self::$defaults['child'] ); ?> class="<?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
						<a href="<?php echo esc_url( $category_link ); ?>"><?php echo esc_html( $parent_category->name ); ?></a>
					</<?php echo esc_attr( self::$defaults['child'] ); ?>>
					<?php
					self::sep();

				}

				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( single_cat_title( '', false ) ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			} elseif ( is_tag() ) {

				// Get tag information
				$term_id       = get_query_var( 'tag_id' );
				$taxonomy      = 'post_tag';
				$args          = 'include=' . $term_id;
				$terms         = get_terms( $taxonomy, $args );
				$get_term_name = $terms[0]->name;

				// Display the tag name
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( $get_term_name ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			} elseif ( is_day() ) {

				// Day archive

				// Year link
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="<?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<a href="<?php echo esc_url( get_year_link( get_the_time( 'Y' ) ) ); ?>"><?php echo esc_html( get_the_time( 'Y' ) . ' Archives' ); ?></a>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php
				self::sep();

				// Month link
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="<?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<a href="<?php echo esc_url( get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) ); ?>"><?php echo esc_html( get_the_time( 'M' ) . ' Archives' ); ?></a>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php
				self::sep();

				// Day display
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( get_the_time( 'jS' ) . ' ' . get_the_time( 'M' ) . ' Archives' ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			} elseif ( is_month() ) {

				// Month archive

				// Year link
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="<?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<a href="<?php echo esc_url( get_year_link( get_the_time( 'Y' ) ) ); ?>"><?php echo esc_html( get_the_time( 'Y' ) . ' Archives' ); ?></a>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php
				self::sep();

				// Month Display
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( get_the_time( 'M' ) . ' Archives' ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			} elseif ( is_year() ) {

				// Year Display
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( get_the_time( 'M' ) . ' Archives' ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			} elseif ( is_author() ) {

				// Auhor archive

				// Get the author information
				global $author;
				$userdata = get_userdata( $author );

				// Display author name
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( 'Author: ' . $userdata->display_name ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			} else {

				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( post_type_archive_title() ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			}
		}
	}

	public static function page() {
		if ( is_page() ) {
			global $post;
			// Standard page
			if ( $post->post_parent ) {

				// If child page, get parents
				$anc = get_post_ancestors( $post->ID );

				// Get parents in the right order
				$anc = array_reverse( $anc );

				// Parent page loop
				if ( ! isset( $parents ) ) {
					$parents = null;
				}
				foreach ( $anc as $ancestor ) {
					ob_start();
					?>
					<<?php echo esc_attr( self::$defaults['child'] ); ?> class="<?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
						<a href="<?php echo esc_url( get_permalink( $ancestor ) ); ?>"><?php echo esc_html( get_the_title( $ancestor ) ); ?></a>
					</<?php echo esc_attr( self::$defaults['child'] ); ?>>
					<?php
					self::sep();
					$parents .= ob_get_clean();

				}

				// Display parent pages
				echo sprintf( '%s', $parents );

				// Current page
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( get_the_title() ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			} else {

				// Just display current page if not parents
				?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( get_the_title() ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

			}
		}
	}

	public static function search() {
		if ( is_search() ) {

			?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="item-current active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( 'Search results for: ' . get_search_query() ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

		}
	}

	public static function error_404() {
		if ( is_404() ) {

			// 404 page
			?>
				<<?php echo esc_attr( self::$defaults['child'] ); ?> class="active <?php echo esc_attr( self::$defaults['child_class'] ); ?>" id="<?php echo esc_attr( self::$defaults['child_id'] ); ?>">
					<span><?php echo esc_html( 'Error 404' ); ?></span>
				</<?php echo esc_attr( self::$defaults['child'] ); ?>>
				<?php

		}
	}
}
