<?php
get_header();
$opt = lifeline()->options();

$style = lifeline_get( $opt, 'team_listing_style' );

$layout =  lifeline_get( $opt, 'teamlayout' ) != 'full' ? lifeline_get( $opt, 'teamlayout' ) : ''; 
$sidebar = lifeline_get( $opt, 'teamSidebar' );
$col     = ( $layout != 'full' && $layout ) ? '9' : '10 mx-auto'; // phpcs:ignore WordPress
?>

?>
<section class="gap">
	<div <?php post_class( 'pt-80 pb-50 bg-gray position-relative w-100' ); ?>>
		<div class="container">
			<div class="row">
				<?php
				if ( $layout == 'left' && is_active_sidebar( $sidebar ) && $style != 'grid' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				?>
				<div class="col-md-12 col-sm-12 col-lg-<?php echo esc_attr( $col ); ?>">
				<?php get_template_part( "templates/team/team-{$style}" ); ?>
				</div>
				<?php
				if ( $layout == 'right' && is_active_sidebar( $sidebar ) && $style != 'grid' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				?>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
