<?php

$opt         = lifeline()->options();
$label       = lifeline_get( $opt, 'story_list_label', 4 );
$title_limit = lifeline_get( $opt, 'story_list_title_character_limit', 15 );
$class       = array(
	'col-md-6',
	'col-sm-12',
	'col-lg-6',
);
?>
<div class="row">
	<?php
	while ( have_posts() ) :
		the_post();
		$meta = lifeline()->meta();
		?>
		<div class="<?php echo implode( ' ', $class ); ?>">

			<div class="fancy-project mb-40 position-relative overflow-hidden rounded w-100">
				<?php echo get_the_post_thumbnail( get_the_ID(), 'lifeline_555x360', array( 'class' => 'img-fluid w-100' ) ); ?>
				<div class="fancy-info position-absolute">
					<div class="fancy-cause-donation">
						<span class="d-block font-weight-semibold text-white"><?php echo lifeline_cm_price_with_symble( lifeline_get( $meta, 'project_cost' ) ); ?></span>
						<i class="font-style-normal d-block text-white"><?php echo esc_html( lifeline_get( $meta, 'money_title' ) ); ?></i>
					</div>
					<h3 class="mb-0 font-weight-semibold">
						<a href="<?php echo esc_url( get_the_permalink( get_the_ID() ) ); ?>" title="<?php the_title_attribute(); ?>"><?php echo wp_trim_words( get_the_title(), $title_limit, '' ); ?></a>
					</h3>
					<a class="theme-btn mt-50 d-inline-block bg-theme overflow-hidden text-white align-self-center align-middle position-relative rounded font-weight-bold" href="<?php echo esc_url( get_the_permalink( get_the_ID() ) ); ?>" title="<?php esc_attr_e( 'Read More', 'lifeline-plugin' ); ?>"><?php echo esc_html( $label ); ?></a>
				</div>
			</div>
		</div>
		<?php
	endwhile;
	lifeline_the_pagination();
	?>
</div>
