<?php
$opt         = lifeline()->options();
$cols        = lifeline_get( $opt, 'story_list_column', 4 );
$title_limit = lifeline_get( $opt, 'story_list_title_character_limit', 15 );

while ( have_posts() ) :
	the_post();
	$meta = lifeline()->meta(); ?>
	<div class="col-md-<?php echo esc_attr( $cols ); ?> col-sm-6 col-lg-<?php echo esc_attr( $cols ); ?>">
		<div class="cause-box w-100 mb-40 rounded" style="border: 0.0625rem solid <?php echo esc_attr( lifeline_get( $meta, 'border_color' ) ); ?>;box-shadow: 0 0.625rem 0 0 <?php echo esc_attr( lifeline_get( $meta, 'border_color' ) ); ?>;">
			<div class="cause-thumb rounded w-100 overflow-hidden position-relative">
				<?php the_post_thumbnail( 'lifeline_523x428', array( 'class' => 'img-fluid w-100' ) ); ?>
				<a class="center-content position-absolute" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><i class="fas fa-plus"></i>
				</a>
			</div>
			<div class="cause-info w-100">
				<?php if ( lifeline_get( $meta, 'location' ) ) : ?>
					<span class="text-theme d-block">
						<i class="fas fa-map-marker-alt"></i><?php echo esc_html( lifeline_get( $meta, 'location' ) ); ?>
					</span>
				<?php endif; ?>
				<h3 class="mb-0">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
						<?php echo wp_trim_words( get_the_title(), $title_limit, '' ); ?>
					</a>
				</h3>
				<?php if ( lifeline_get( $meta, 'project_cost' ) ) : ?>
					<div class="font-family-poppins justify-content-between d-flex spnt-bar">
						<i class="font-style-normal"><?php esc_html_e( 'Money Spent', 'lifeline' ); ?></i>
						<span class="font-weight-bold text-dark d-inline-block">
							<?php echo lifeline_cm_price_with_symble( lifeline_get( $meta, 'project_cost' ) ); ?>
						</span>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<?php

endwhile;
lifeline_the_pagination();
