<?php
$opt         = lifeline()->options();
$title_limit = lifeline_get( $opt, 'services_list_title_character_limit', '15' );
$desc_limit  = lifeline_get( $opt, 'services_list_character_limit', '15' );
$cols        = lifeline_get( $opt, 'services_list_column', '4' );

$class = array(
	'col-sm-6',
	"col-md-{$cols}",
	"col-md-{$cols}",
);
while ( have_posts() ) {
	the_post();
	$meta = lifeline()->meta( get_the_ID() );
	?>
	<div class="<?php echo implode( ' ', $class ); ?>">
		<div class="mb-50 service-wrap4 w-100 position-relative text-center opc8 black-layer" style="background-image: url(<?php echo get_the_post_thumbnail_url( get_the_ID(), 'full' ); ?>);">
			<div class="service-box4 w-100 position-relative">
				<?php if ( lifeline_get( $meta, 'icon_svg' ) ) : ?>
					<i class="d-inline-block rounded-circle bg-theme">
						<?php lifeline_svg_print( lifeline_get( $meta, 'icon_svg.url' ) ); ?>
					</i>
				<?php endif; ?>
				<div class="service-info4 rounded position-relative">
					<h3 class="mb-0 font-weight-semibold text-dark"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php echo wp_trim_words( get_the_title(), $title_limit, '' ); ?></a></h3>
					<p class="mb-0"><?php echo wp_trim_words( get_the_content(), $desc_limit, '' ); ?></p>
				</div>
			</div>
		</div>
	</div>
	<?php
}
lifeline_the_pagination();
