<?php
$option      = lifeline()->options();
$cols        = lifeline_get($option, 'project_list_column', '6');
$title_limit = lifeline_get($option, 'project_list_title_character_limit', '15');

$thumbnail_size = lifeline_get($option, 'project_list_column') == '6' ? [300, 200] : [546, 410];

$meta            = lifeline()->meta(get_the_ID());
$meta            = lifeline_get($meta, 'project_settings');
$post            = get_post(get_the_ID());
$spent_money     = lifeline_get($option, 'project_list_spend_money');
$donation_needed = (lifeline_get($meta, 'donation')) ? lifeline_get($meta, 'donation') : 0;
$collect_amt     = \WebinaneCommerce\Classes\Orders::get_items_total($post);
if ($collect_amt != 0 && $donation_needed != 0) {
	$donation_percentage = ($collect_amt / $donation_needed) * 100;
} else {
	$donation_percentage = 0;
}
?>
<div class="col-md-<?php echo esc_attr($cols); ?> col-sm-6 col-lg-<?php echo esc_attr($cols); ?>">
	<div class="project-box mb-30 overflow-hidden position-relative w-100">
		<figure>
			<?php if (class_exists('Lifeline_Resizer')): ?>
				<?php $img_obj = new lifeline_Resizer(); ?>
				<?php echo wp_kses_post($img_obj->lifeline_resize(wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()), 'full'), $thumbnail_size[0], $thumbnail_size[1], true)); ?>
			<?php else: ?>
				<?php the_post_thumbnail('full'); ?>
			<?php endif; ?>
			<div class="project-link-box">
				<a class="center-content position-absolute" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" tabindex="-1">
					<i class="fas fa-plus"></i>
				</a>
			</div>
		</figure>
		<div class="project-info w-100">
			<h3 class="mb-0">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" tabindex="-1"><?php echo wp_trim_words(get_the_title(), $title_limit, ''); ?>
				</a>
			</h3>
			<div class="font-family-poppins justify-content-between d-flex goal-bar">
				<?php
				if ($spent_money) { ?>
					<span class="font-weight-bold">
						<span class="font-weight-normal"><?php esc_html_e('Spent: ', 'lifeline'); ?>
						</span>

						<?php echo lifeline_cm_price_with_symble($collect_amt); ?>
					</span>
				<?php } ?>
			</div>
		</div>
	</div>
</div>