<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       1.0.0
 */

$options = lifeline()->options();
if ( lifeline_get( $options, 'top_bar_social' ) ) {
	$profile = lifeline_get( $options, 'top_bar_social_media' );
	if ( ! $profile ) {
		return;
	}
	?>
	<div class="social-medias float-right">
		<?php
		foreach ( $profile as $icon ) :
			$icon = json_decode( urldecode( lifeline_get( $icon, 'data' ) ), true );
			if ( $icon['enable'] == true ) {
				?>
				<a class="text-theme position-relative d-inline-block" href="<?php echo esc_url( lifeline_get( $icon, 'url' ) ); ?>" title="<?php echo esc_attr( str_replace( array( 'fa-', '-' ), array( '', ' ' ), lifeline_get( $icon, 'icon' ) ) ); ?>"><i class="fab <?php echo ( lifeline_get( $icon, 'icon' ) ); ?>"></i></a>
				<?php
			}
		endforeach;
		do_action( 'wpml_add_language_selector' );
		?>

	</div>
	<?php
}