<?php

/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       1.0.0
 */


$options = lifeline()->options();
$bg      = lifeline_get( $options, 'singin_box_bg.background-image' );
$form_id = md5( 'lifelin2' );
?>
<div id="login" class="lifeline-forms-builder popup-wrap position-fixed modal fade center" tabindex="-1" role="dialog">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-body">
				<div class="login-form popup-form position-absolute center-content overflow-hidden w-100">
					<button type="button" class="close-btn text-theme position-absolute close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true"><i class="fas fa-times bg-white d-block text-center"></i></span>
					</button>
					<?php echo ( lifeline_get( $options, 'signin_form_title' ) ) ? '<strong class="text-white font-family-poppins font-weight-bold d-block">' . lifeline_color( lifeline_get( $options, 'signin_form_title' ) ) . '</strong>' : ''; ?>
					<?php echo ( lifeline_get( $options, 'signin_form_description' ) ) ? '<p>' . wp_kses( lifeline_get( $options, 'signin_form_description' ), true ) . '</p>' : ''; ?>

					<form class="w-100">
						<input class="border-0 w-100 rounded" name="log" id="user_login" type="text" placeholder="<?php esc_attr_e( 'Username', 'lifeline' ); ?>">
						<input class="border-0 w-100 rounded" name="pwd" id="user_pass" type="password" placeholder="<?php esc_attr_e( 'Password', 'lifeline' ); ?>">
						<?php if ( lifeline_get( $options, 'show_forgot_pass' ) ) : ?>
							<p><a href="<?php echo esc_url( wp_lostpassword_url() ); ?>" title="<?php esc_attr_e( 'Forgot Password', 'lifeline' ); ?>"><?php esc_html_e( 'Forgot Password', 'lifeline' ); ?></a></p>
						<?php endif; ?>
						<?php wp_nonce_field( 'ajax-login-nonce', 'security' ); ?>
						<input type="hidden" name="form_validate" value="login" />
						<input class="redirect_url" type="hidden" name="redirect_url" value="<?php echo esc_url( get_the_permalink( lifeline_get( $options, 'account_link' ) ) ); ?>">
						<button data-form="<?php echo esc_attr( $form_id ); ?>" class="theme-btn bg-theme overflow-hidden d-inline-block text-white position-relative rounded font-weight-bold" type="submit"><?php echo esc_html( lifeline_get( $options, 'signin_form_btn_label' ) ); ?></button>
					</form>
				</div>
			</div>
		</div>
	</div>
</div><!-- Popup Wrap -->
