<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       1.0.0
 */

$options = lifeline()->options();
$address = lifeline_get( $options, 'top_bar_address' );
$contact = lifeline_get( $options, 'top_bar_phone' );
$email = lifeline_get( $options, 'top_bar_email' );
?>

<ul class="list-unstyled d-sm-flex">
	<?php if ( $address ) : ?>
    	<li>
    		<strong><?php esc_html_e( 'Location', 'lifeline'); ?>:</strong>
    		<span><?php echo esc_html( $address ); ?></span>
    	</li>
    <?php endif; ?>
    <?php if ( $contact ) : ?>
    	<li>
    		<strong><?php esc_html_e( 'Phone', 'lifeline'); ?>:</strong>    		
<span><?php echo esc_html( $contact ); ?></span>
    	</li>
    <?php endif; ?>
    <?php if ( $email ) : ?>
    	<li>
    		<strong><?php esc_html_e( 'Email', 'lifeline'); ?>:</strong>
    		<span><?php echo esc_html( $email ); ?></span>
    	</li>
    <?php endif; ?>
</ul>