<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       1.0.0
 */

$options = lifeline()->options();
$address = lifeline_get( $options, 'top_bar_address' );
$contact = lifeline_get( $options, 'top_bar_phone' );
$email = lifeline_get( $options, 'top_bar_email' );
?>

<ul class="list-unstyled d-sm-flex">
	<?php if ( $address ) : ?>
    	<li>
    		<i class="fas fa-map-marker mr-2"></i>
    		<span><?php echo esc_html( $address ); ?></span>
    	</li>
    <?php endif; ?>
    <?php if ( $contact ) : ?>
    	<li>
    		<i class="fas fa-headphones mr-2"></i>
    		<span><?php echo esc_html( $contact ); ?></span>
    	</li>
    <?php endif; ?>
    <?php if ( $email ) : ?>
    	<li>
    		<i class="fas fa-envelope  mr-2"></i>
    		<span><?php echo esc_html( $email ); ?></span>
    	</li>
    <?php endif; ?>
</ul>