<?php 
if ( class_exists( 'woocommerce' ) ) :

global $woocommerce; 
$cart_count = WC()->cart->get_cart_contents_count();
?>
	<div class="custom-mini-cart">
		<div class="popup-main">
			<div class="cross-bar" onclick="myFunction(this)">
				<div class="bar1"></div>
				<div class="bar2"></div>
				<div class="bar3"></div>
			</div>
			<h2><?php echo esc_html__( 'Basket', 'hair-cutter' ); ?> (<?php echo esc_attr( $cart_count ); ?>)</h2>
			<?php 
			if ( $cart_count > 0 ) {
				$count = 0;
				$cart_item_count = count( WC()->cart->get_cart() );
				foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
					$count++;
					
					$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
					$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

					if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
						$product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
						$thumbnail         = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image( 'thumbnail' ), $cart_item, $cart_item_key );
						$product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
						$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );

						$rating  = $_product->get_average_rating();
						$rating_count   = $_product->get_rating_count();
						?>
						<div class="cart-item position-relative woocommerce-mini-cart-item">
							<?php
							echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
								'woocommerce_cart_item_remove_link',
								sprintf(
									'<a href="%s" class="remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s">&times;</a>',
									esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
									esc_attr__( 'Remove this item', 'woocommerce' ),
									esc_attr( $product_id ),
									esc_attr( $cart_item_key ),
									esc_attr( $_product->get_sku() )
								),
								$cart_item_key
							);
							?>

							<div class="cart-item d-flex align-items-center">
								<?php echo $thumbnail; ?>
								<div class="featured-area cart-1 position-relative">
									<?php echo wc_get_rating_html( $rating, $rating_count ); ?>
									<h2><a href="<?php echo esc_url( get_the_permalink( $product_id ) ); ?>"><?php echo $product_name; ?>
									</a></h2>
									<!-- <div class="featured-sub">
										<?php echo $product_price; ?>
									</div> -->
									<?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
								</div>
								<a href="<?php echo esc_url( get_the_permalink( $product_id ) ) ?>" class="popuo-button">
									<i class="fa fa-plus"></i>
									<span class="featured-btn"><?php echo esc_html__( 'View Product', 'hair-cutter' ); ?></span>
								</a>
							</div>
						</div>
						<?php if ( $cart_item_count != $count ) : ?>
							<hr>
						<?php endif; ?>
						<?php
					}
				}
			}
			?>
		</div>
		<hr>
		<?php if ( $cart_count > 0 ) : ?>
			<div class="cart-price d-flex justify-content-between">
				<h2><?php echo esc_html__( 'Total:', 'hair-cutter' ); ?></h2>
				<h2><?php echo WC()->cart->get_total() ?></h2>
			</div>
			<a href="<?php echo esc_url( wc_get_checkout_url() ) ?>" class="theme-btn-2">
				<?php echo esc_html__( 'Cart & Checkout', 'hair-cutter' ); ?>
			</a>
		<?php endif; ?>
	</div>
<?php endif;

