<?php

	$opt         = lifeline()->options();
	$cols        = lifeline_get( $opt, 'event_list_column', '6' );
	$title_limit = lifeline_get( $opt, 'event_list_title_character_limit', '15' );

	$class = array(
		'col-sm-12',
		'col-md-6',
		"col-lg-{$cols}",
	);


while ( have_posts() ) :
	the_post();
	?>
	<div class="<?php echo implode( ' ', $class ); ?>">
		<div class="event-style3">
			<div class="event-img position-relative">
				<figure class="mb-0">
					<?php the_post_thumbnail( 'lifeline_546x370', array( 'class' => 'img-fluid w-100' ) ); ?>
				</figure>
				<span class="bg-theme-light text-white position-absolute d-inline-block"><i class="fas fa-calendar mr-3"></i><?php echo date_i18n( 'F j, Y', strtotime( get_post_meta(  get_the_ID(), 'start_date-datepicker', true ) ) ); ?> </span>
			</div>
			<div class="event-txt">
				<h3><a href="<?php the_permalink(); ?>" title="">	<?php echo wp_trim_words( get_the_title(), $title_limit, '' ); ?></a></h3>
				<span><i class="fas fa-map-marker-alt theme-text-light mr-3"></i><?php echo get_post_meta( get_the_ID(), 'event_location', true ); ?></span>
			</div>
		</div>
	</div>
<?php
endwhile;
lifeline_the_pagination_blog();
