<div class="event-detail">
	<div class="event-img">
		<?php the_post_thumbnail( 'lifeline_955x530', array( 'class' => 'img-fluid w-100' ) ); ?>
	</div>
	<div class="event-upper-content">
		<h2><?php the_title(); ?></h2>
		<div class="row">
			<?php if ( $date_s && $date_e  && $show_detail ) : ?>
				<div class="col-md-6">
					<div class="event-info">
						<h4><?php echo esc_html($detail_label); ?></h4>
						<ul class="list-unstyled pl-0 mb-0">

							<li>
								<div class="d-sm-flex">
								    <span><?php esc_html_e( 'Start Date:', 'lifeline'); ?></span>	
								    <span><?php echo date_i18n( 'd-m-Y', strtotime( get_post_meta(  get_the_ID(), 'start_date', true ) ) ); ?></span>
								</div>
								<div class="d-sm-flex">
								    <span><?php esc_html_e( 'End Date:', 'lifeline'); ?></span>	
								    <span><?php echo date_i18n( 'd-m-Y', strtotime( get_post_meta(  get_the_ID(), 'end_dateee', true ) ) ); ?></span>
								</div>
							</li>
							<li>
								<div class="d-sm-flex">
								    <span><?php esc_html_e( 'Start Time:', 'lifeline'); ?></span>	
								    <span><?php echo date_i18n( 'h:i', strtotime( get_post_meta(  get_the_ID(), 'start_date', true ) ) ); ?></span>
								</div>
							</li>
							<li>
								<div class="d-sm-flex">
								    <span><?php esc_html_e( 'End Time:', 'lifeline'); ?></span>	
								    <span><?php echo date_i18n( 'h:i', strtotime( get_post_meta(  get_the_ID(), 'end_dateee', true ) ) ); ?></span>
								</div>
							</li>
							<?php if ( $location ) : ?>
								<li>
									<div class="d-sm-flex">
									    <span><?php esc_html_e('Location:', 'lifeline'); ?></span>	
									    <span><?php echo esc_html( $location ); ?></span>
									</div>
								</li>
							<?php endif; ?>
						</ul>
					</div>
				</div>
			<?php endif; ?>
			<?php if ( $date_s && $date_e  && $show_detail ) : ?>
				<div class="col-md-6">
					<div class="event-organizor">
					<h4><?php echo esc_html(lifeline_get( $opt, 'organizer_info_section_label' )); ?></h4>
					<ul class="list-unstyled pl-0 mb-0">
						<?php if ($name) : ?>
							<li class="d-sm-flex">
								<span><?php esc_html_e( 'By:', 'lifeline' ); ?></span>
								<span class="theme-text-light"><?php echo esc_html( $name ); ?>		</span>
							</li>
						<?php endif; ?>
						<?php if ($number) : ?>
							<li class="d-sm-flex">
								<span><?php esc_html_e( 'Mobile:', 'lifeline' ); ?></span>
								<span class="theme-text-light"><?php echo $number; ?></span>
							</li>
						<?php endif; ?>
						<?php if ($email) : ?>
							<li class="d-sm-flex">
								<span><?php esc_html_e( 'Email:', 'lifeline' ); ?>
									
								</span>
								<span class="theme-text-light"><?php echo $email; ?></span>
							</li>
						<?php endif; ?>
						<li class="d-sm-flex">
							<span><?php esc_html_e( 'Website:', 'lifeline' ); ?></span>
							<span class="theme-text-light">
							<?php echo esc_html( $website ); ?></span>
						</li>
						</ul>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</div>
		<?php the_content(); ?>
		<div class="event-tags">
			 <?php
					$terms = wp_get_post_terms( get_the_ID(), 'event_category');
					if ($terms){
				    foreach ( $terms as $term ) {
				      
				      
				       echo '<span>'.lifeline_get($term,'name').'</span>';
				       }
				}
			  ?>

		</div>
</div>