<?php
$opt         = lifeline()->options();
$title_limit = lifeline_get( $opt, 'causes_list_title_character_limit', 15 );
$text_limit  = lifeline_get( $opt, 'causes_list_character_limit', 25 );
$cols        = lifeline_get( $opt, 'causes_list_column', 4 );
$collection  = lifeline_get( $opt, 'causes_list_current_label', 'Current Collection' );
$target      = lifeline_get( $opt, 'causes_list_target_label', 'Target Collection' );
$label       = lifeline_get( $opt, 'causes_list_btn_label', 'Donate Now' );

wp_enqueue_script( 'barfiller' );
while ( have_posts() ) :
	the_post();
	$meta            = lifeline()->meta( get_the_ID() );
	$cause_settings  = lifeline_get( $meta, 'causes_settings' );
	$donation_needed = ( lifeline_get( $cause_settings, 'donation' ) ) ? lifeline_get( $cause_settings, 'donation' ) : 0;
	$post            = get_post( get_the_ID() );
	$collect_amt     = \WebinaneCommerce\Classes\Orders::get_items_total( $post );
	if ( $collect_amt != 0 && $donation_needed != 0 ) { // phpcs:ignore WordPress
		$donation_percentage = ( $collect_amt / $donation_needed ) * 100;
	} else {
		$donation_percentage = 0;
	}
	?>
	<div class="urgentcause-box w-100 pb-50">
		<div class="row align-items-center">
			<div class="col-md-12 col-sm-12 col-lg-6 order-lg-1 text-right">
				<?php
				if ( lifeline_get( $cause_settings, 'donation_cause_gallery' ) == 'gallery' ) : // phpcs:ignore WordPress
					$gallery = explode( ',', lifeline_get( $cause_settings, 'donation_cause_gallery' ) );
					?>
					<div class="urgentcause-thumb w-100 position-relative" data-js="urgentcause-gallery">
						<?php
						foreach ( $gallery as $key => $value ) {
							echo wp_get_attachment_image( $value, '370x380' );
						}
						?>
					</div>
				<?php else : ?>
					<?php echo get_the_post_thumbnail( get_the_ID(), 'lifeline_555x389', array( 'class' => 'img-fluid w-100' ) ); ?>
				<?php endif; ?>
			</div>
			<div class="col-md-12 col-sm-12 col-lg-6">
				<div class="urgentcause-info w-100 mt-lg-0 mt-5 mt-sm-5">
					<?php if ( lifeline_get( $cause_settings, 'location' ) ) : ?>
						<span class="text-theme"><i class="fas fa-map-marker-alt"></i><?php echo esc_html( lifeline_get( $cause_settings, 'location' ) ); ?></span>
					<?php endif; ?>
					<h3 class="mb-0">
						<a href="<?php echo get_the_permalink( get_the_ID() ); ?>"><?php echo wp_trim_words( $post->post_title, $title_limit, '' ); ?></a>
					</h3>
					<p class="mb-0">
						<?php echo wp_trim_words( $post->post_content, $text_limit, '' ); ?>
					</p>
					<div class="cause-target w-100">
						<?php if ( $collection ) : ?>
							<div class="cause-amount d-inline-block position-relative">
								<span class="font-family-poppins text-dark d-block font-weight-bold">
									<?php echo lifeline_cm_price_with_symble( $donation_needed ); ?>
								</span>
								<h6 class="font-weight-normal mb-0"><?php echo esc_html( $collection ); ?></h6>
							</div>
						<?php endif; ?>
						<?php if ( $target ) : ?>
							<div class="cause-amount d-inline-block position-relative">
								<span class="font-family-poppins text-dark d-block font-weight-bold">
									<?php echo lifeline_cm_price_with_symble( $collect_amt ); ?>
								</span>
								<h6 class="font-weight-normal mb-0">
									<?php echo esc_html( $target ); ?>
								</h6>
							</div>
						<?php endif; ?>
					</div>
					<div class="cause-progress w-100 d-sm-flex align-items-center">
						<div class="progress-wrap w-100 align-middle d-inline-block">
							<?php $class = uniqid( 'lifeline-' ); ?>
							<div class="barfiller bg-white <?php echo esc_attr( $class ); ?>">
								<div class="tipWrap">
									<span class="tip"><?php echo esc_attr( round( $donation_percentage, 0 ) ); ?>%</span>
								</div>
								<span class="fill" data-percentage="<?php echo esc_attr( round( $donation_percentage, 0 ) ); ?>"></span>
							</div>
						</div>
						<?php
						if ( $label ) :
							$class = 'theme-btn bg-theme overflow-hidden d-inline-block text-white align-self-center align-middle position-relative rounded font-weight-bold';
							lifeline_donation_button_post( $class, $label );
						endif;
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
	$script = "jQuery(document).ready(function($){
    $('.barfiller." . $class . "').barfiller({
        duration: 3000,
        barColor: '',
      });
})";
	wp_add_inline_script( 'barfiller', $script );
endwhile;
lifeline_the_pagination();
?>

<script type="text/javascript">
	var width = window.innerWidth;
	if(width > 900 || width < 500 ){
		jQuery('.urgentcause-thumb > img:first').css({
			'transform': 'translate(0)',
			'z-index': '3'
		});
		jQuery('.urgentcause-thumb > img:nth-child(2)').css({
			'transform': 'translate(2.8125rem, 2.8125rem)',
			'z-index': '2'
		});
		jQuery('.urgentcause-thumb > img:nth-child(3)').css({
			'transform': 'translate(5.625rem, 5.625rem)',
			'z-index': '1'
		});
		jQuery('.urgentcause-thumb > img:first').on('click', function() {
			jQuery('.urgentcause-thumb > img:nth-child(2)').css({
				'transform': 'translate(2.8125rem, 2.8125rem)',
				'z-index': '2'
			});
			jQuery('.urgentcause-thumb > img:nth-child(3)').css({
				'transform': 'translate(5.625rem, 5.625rem)',
				'z-index': '1'
			});
			jQuery(this).css({
				'transform': 'translate(0)',
				'z-index': '3'
			});
		});
		jQuery('.urgentcause-thumb > img:nth-child(2)').on('click', function() {
			jQuery('.urgentcause-thumb > img:first').css({
				'transform': 'translate(5.625rem, 5.625rem)',
				'z-index': '1'
			});
			jQuery('.urgentcause-thumb > img:nth-child(3)').css({
				'transform': 'translate(2.8125rem, 2.8125rem)',
				'z-index': '2'
			});
			jQuery(this).css({
				'transform': 'translate(0)',
				'z-index': '3'
			});
		});
		jQuery('.urgentcause-thumb > img:nth-child(3)').on('click', function() {
			jQuery('.urgentcause-thumb > img:first').css({
				'transform': 'translate(2.8125rem, 2.8125rem)',
				'z-index': '2'
			});
			jQuery('.urgentcause-thumb > img:nth-child(2)').css({
				'transform': 'translate(5.625rem, 5.625rem)',
				'z-index': '1'
			});
			jQuery(this).css({
				'transform': 'translate(0)',
				'z-index': '3'
			});
		});
	}
</script>
