<?php
$opt    = lifeline()->options();
$date   = lifeline_get( $opt, 'blog_post_date' );
$class  = lifeline_get( $opt, 'blog_column' );
$cat        = lifeline_get( $opt, 'blog_post_tags' );
$comments = lifeline_get( $opt, 'blog_post_comments' );
$content    = lifeline_get( $opt, 'character_limit', 15 );
$title  = lifeline_get( $opt, 'title_character_limit', 5 );
$featured_post = lifeline_get( $opt, 'blog_feature_post' );

if ( function_exists( 'lifeline_encrypt' ) ) {
	$load_more = lifeline_encrypt(
		array(
			'desc_limit'     => $title,
			'title_limit'    => $content,
			'paged'          => max( 1, get_query_var( 'paged' ) ),
			'posts_per_page' => get_option( 'posts_per_page' ),
		)
	);
} else {
	$load_more = '';
}

$args = array(
    'post_type'      => '',
    'post__in'   => array( $featured_post ),
);

$featured_post = new WP_Query( $args );

?>

<?php if ( $featured_post->have_posts() ) : ?>
    <?php while ( $featured_post->have_posts() ) : ?>
        <?php $featured_post->the_post(); ?>
        <div class="blog-featured-post grid_style2">
            <?php 
                if ( has_post_thumbnail() ) {
                    the_post_thumbnail( 'lifeline_870x410', array( 'class' => 'img-fluid w-100' ) );
                }
            ?>
            <div class="featured-post-content">
                <span>Featured Article</span>
                <h3>
                    <a href="<?php the_permalink(); ?>">
                        <?php echo get_the_title(); ?>
                    </a>
                </h3>
                <ul>
                    <?php if ( $cat ) : ?>
                        <li class="blog-category">
                            <?php echo get_the_category_list( "," ); ?>
                        </li>
                    <?php endif; ?>
                    <?php if ( $date  ) : ?>
                        <li>
                            <?php 
                                $archive_year  = get_the_time( 'Y' ); 
                                $archive_month = get_the_time( 'm' ); 
                                $archive_day   = get_the_time( 'd' ); 
                            ?>
                            <i class="fas fa-calendar"></i>
                            <a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    <?php endwhile; ?>
<?php endif; ?>

<div class="row post-listing">
	<?php if ( have_posts()  ) : ?>
		<?php while ( have_posts() ) : ?>
			<?php the_post(); ?>
			<div class="col-md-<?php echo $class; ?>">
				<div class="blog-post grid_style2">
					<div class="blog-media">
						<?php 
							if ( has_post_thumbnail() ) {
								the_post_thumbnail( 'lifeline_870x410', array( 'class' => 'img-fluid w-100' ) );
							}
						?>
					</div>
					<div class="blog-content">
                        <ul>
                            <?php if ( $cat ) : ?>
                                <li class="blog-category">
                                    <?php echo get_the_category_list( "," ); ?>
                                </li>
                            <?php endif; ?>
                            <?php if ( $date  ) : ?>
								<li>
									<?php 
										$archive_year  = get_the_time( 'Y' ); 
										$archive_month = get_the_time( 'm' ); 
										$archive_day   = get_the_time( 'd' ); 
									?>
									<i class="fas fa-calendar"></i>
									<a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>
								</li>
							<?php endif; ?>
                        </ul>
						<h3>
							<a href="<?php the_permalink(); ?>">
								<?php
									if ( ! empty(  lifeline_get( $opt, 'title_character_limit' )  )  ) {
										echo wp_trim_words( get_the_title(), lifeline_get( $opt, 'title_character_limit', 5 ), '' );
									} else {
										echo get_the_title();
									}
								?>
							</a>
						</h3>
                        <a href="<?php the_permalink(); ?>">
                                <?php echo esc_html_e( 'View Article', 'lifeline' ) ?>
                                <i class="fa fa-arrow-right"></i>
                        </a>
					</div>
				</div>
			</div>
		<?php endwhile; ?>
	<?php endif; ?>
</div>
<div class="loadmore-wrap" style="margin:auto;">
    <div id="loadMore"><?php next_posts_link( 'LOAD MORE ARTICLES' ); ?></div>
</div>