<?php
$opt    = lifeline()->options();
$date   = lifeline_get( $opt, 'blog_post_date' );
$class  = lifeline_get( $opt, 'blog_column' );
$comments = lifeline_get( $opt, 'blog_post_comments' );
$content    = lifeline_get( $opt, 'character_limit', 15 );
$title  = lifeline_get( $opt, 'title_character_limit', 5 );
$pagination = lifeline_get( $opt, 'paginstion' ) ? lifeline_get( $opt, 'paginstion' ) : 0;

if ( function_exists( 'lifeline_encrypt' ) ) {
	$load_more = lifeline_encrypt(
		array(
			'desc_limit'     => $title,
			'title_limit'    => $content,
			'paged'          => max( 1, get_query_var( 'paged' ) ),
			'posts_per_page' => get_option( 'posts_per_page' ),
		)
	);
} else {
	$load_more = '';
}

?>

	<?php if ( have_posts()  ) : ?>
		<?php while ( have_posts() ) : ?>
			<?php the_post(); ?>
			<div class="col-md-<?php echo $class; ?>">
				<div class="blog-post grid_style1">
					<div class="blog-media">
						<?php 
							if ( has_post_thumbnail() ) {
								the_post_thumbnail( 'lifeline_350x280', array( 'class' => 'img-fluid' ) );
							}
						?>
						<ul class="blog-meta">
							<?php if ( $date  ) : ?>
								<li class="bg-white">
									<?php 
										$archive_year  = get_the_time( 'Y' ); 
										$archive_month = get_the_time( 'm' ); 
										$archive_day   = get_the_time( 'd' ); 
									?>
									<i class="fas fa-calendar"></i>
									<a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>
								</li>
							<?php endif; ?>
							<?php if ( $comments  ) : ?>
								<li class="bg-theme-color">
									<i class="fas fa-comment-alt"></i>
									<?php echo get_comments_number(get_the_ID()); ?>
								</li>
							<?php endif; ?>
						</ul>
					</div>
					<div class="blog-content">
						<h3>
							<a href="<?php the_permalink(); ?>">
								<?php
									if ( ! empty(  lifeline_get( $opt, 'blog_title_character_limit' )  )  ) {
										echo wp_trim_words( get_the_title(), lifeline_get( $opt, 'blog_title_character_limit', 5 ), '' );
									} else {
										echo get_the_title();
									}
								?>
							</a>
						</h3>
						<p>
							<?php 
									if ( ! empty( lifeline_get( $opt, 'blog_character_limit' )  ) ) {
										echo wp_trim_words( get_the_content(), lifeline_get( $opt, 'blog_character_limit', 15 ), '' );
									} else {
										echo get_the_content();
									}
								?>
						</p>
					</div>
				</div>
			</div>
		<?php endwhile; ?>
	<?php endif; ?>

<?php if ( ! $pagination ) : ?>
	<a id="press_room" class="load-more d-inline-block w-100 rounded text-center font-weight-extrabold mt-30" href="javascript:void(0);" data-load="<?php echo esc_attr( $load_more ); ?>">
		<i class="fas fa-sync"></i>
		<?php esc_html_e( 'LOAD MORE', 'lifeline' ); ?>
	</a>
	<?php
else :
	lifeline_the_pagination_blog();
endif;