<?php $opt = lifeline()->options(); ?>
<?php $format = get_post_format(); ?>
<div class="blog-post-detail">
	<div class="blog-img position-relative">
		<?php
			if ( $format == 'video' ) { 
				get_template_part( 'templates/blog-details/video' );
			} elseif ( $format == 'audio' ) { 
				get_template_part( 'templates/blog-details/audio' );
			} elseif ( $format == 'gallery' ) { 
				get_template_part( 'templates/blog-details/gallery' );
			} else {
				get_template_part( 'templates/blog-details/default' );
			}
		?>
		<ul class="blog-meta">
			<?php  if ( lifeline_get( $opt, 's_post_date' )  ) : ?>
				<li>
					<i class="fas fa-calendar theme-text-light mr-2"></i>
					<?php echo get_the_date( 'F j, Y' ); ?>
				</li>
			<?php endif; ?>
			<?php  if ( lifeline_get( $opt, 's_post_author' )  ) : ?>
				<li>
					<i class="fas fa-user theme-text-light mr-2"></i>
					<?php esc_html_e( 'By', 'lifeline' ); ?>
					<?php echo get_the_author(); ?>
			    </li>
			<?php endif; ?>
		</ul>
	</div>
	<div class="blog-content">
		<h2><?php the_title(); ?></h2>
		<?php if ( lifeline_get( $opt, 's_post_cat' ) ) : ?>
			<div class="blog-cat">
				<span class="theme-text-light font-weight-bold">
					<?php esc_html_e('Posted In: ', 'lifeline' ); ?></span>
				<?php echo get_the_category_list( "," ); ?>
			</div>
		<?php endif; ?>
		<?php the_content(); ?>

		<?php  if ( lifeline_get( $opt, 's_post_tags' )  ) : ?>
			<div class="blog-tags">
				<?php echo lifeline_get_tags(); ?>
			</div>
	    <?php endif; ?>
	</div>	
</div>