<?php
get_header();
$meta    = lifeline()->meta( get_the_ID() );
$address = lifeline_get( $meta, 'address' );
$email   = lifeline_get( $meta, 'email' );
$phone   = lifeline_get( $meta, 'phone' );
$profile = lifeline_get( $meta, 'team_social_media' );
$skills  = lifeline_get( $meta, 'skills' );
?>
<section>
	<div id="post-<?php the_ID(); ?>" <?php post_class( 'py-80 bg-gray position-relative w-100' ); ?>>
		<div class="container">
			<div class="team-detail-wrap w-100">
				<div class="row mrg">
					<?php
					while ( have_posts() ) {
						the_post();
						?>
						<div class="col-md-12 col-sm-12 col-lg-6">
							<div class="gen-detail-wrap w-100">
								<div class="team-detail-img w-100 position-relative overflow-hidden">
									<?php the_post_thumbnail( '570x644', array( 'class' => 'img-fluid w-100' ) ); ?>
									<ul class="team-detail-info position-absolute mb-0 list-unstyled text-right">
										<?php if ( $email ) : ?>
											<li class="text-white position-relative rounded overflow-hidden d-table"><span class="position-absolute text-center"><i class="far fa-envelope"></i></span>
												<p class="mb-0 text-left"><i class="font-style-normal"><?php esc_html_e( 'Email', 'lifeline3' ); ?>:</i> <?php echo esc_html( $email ); ?></p>
											</li>
										<?php endif; ?>
										<?php if ( $address ) : ?>
											<li class="text-white position-relative rounded overflow-hidden d-table"><span class="position-absolute text-center"><i class="fas fa-map-marker-alt"></i></span>
												<p class="mb-0 text-left"><i class="font-style-normal"><?php esc_html_e( 'Address', 'lifeline3' ); ?>:</i> <?php echo esc_html( $address ); ?></p>
											</li>
										<?php endif; ?>
										<?php if ( $phone ) : ?>
											<li class="text-white position-relative rounded overflow-hidden d-table"><span class="position-absolute text-center"><i class="fas fa-mobile-alt"></i></span>
												<p class="mb-0 text-left"><i class="font-style-normal"><?php esc_html_e( 'Phone', 'lifeline3' ); ?>:</i> <?php echo esc_html( $phone ); ?></p>
											</li>
										<?php endif; ?>
										<li class="text-white position-relative rounded overflow-hidden d-table"><span class="position-absolute text-center"><i class="fas fa-list"></i></span>
											<p class="mb-0 text-left"><i class="font-style-normal"><?php esc_html_e( 'Category', 'lifeline3' ); ?>:</i> <?php echo get_the_term_list( get_the_ID(), 'team_category', '', ',' ); ?></p>
										</li>
									</ul>
									<?php if ( ! empty( $profile ) ) : ?>
										<div class="position-absolute team-social">
											<span class="text-white"><?php esc_html_e( 'Get In Touch', 'lifeline' ); ?></span>
											<?php
											foreach ( $profile['redux_repeater_data'] as $k => $v ) {
												$icon         = $profile['icon'][ $k ];
												$link         = $profile['link'][ $k ];
												/* $ibg_colorcon = $profile['bg_color'][ $k ];
												$text_color   = $profile['text_color'][ $k ]; */
												?>
												<a class="rounded-circle d-inline-block text-white position-relative" href="<?php echo esc_url( $link ); ?>" title="<?php echo esc_attr( str_replace( array( 'fab fa-', '-' ), array( '', ' ' ), $icon ) ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
												<?php
											}
											?>
										</div><!-- Share This -->
									<?php endif; ?>
								</div>
							</div>
						</div>
						<div class="col-md-12 col-sm-12 col-lg-6">
							<div class="team-desc w-100">
								<h2 class="mb-0 text-dark"><?php the_title(); ?></h2>
								<?php
								the_content();
								if ( $skills ) :
									unset( $skills['redux_repeater_data'] );
									$x           = 0;
									$titles      = sort( $skills['title'] );
									$description = sort( $skills['description'] );
									$icon        = sort( $skills['icon_select_field'] );
									if ( is_array( $titles ) && ! empty( $titles ) ) {
										foreach ( $titles as $v ) {
											?>
											<div class="skills mt-30 d-flex align-items-center w-100">
												<i class="<?php echo esc_attr( lifeline_get( $icon, $x ) ); ?> rounded-circle text-theme text-center"></i>
												<div class="skills-inner">
													<h3 class="mb-0 text-theme font-weight-semibold">
														<?php if ( $titles && is_array( $titles ) ) { ?>
															<?php echo esc_html( lifeline_get( $titles, $x ) ); ?>
													</h3>
												<?php } ?>
												<?php if ( $description && is_array( $description ) ) { ?>
													<p class="mb-0"><?php echo esc_html( lifeline_get( $description, $x ) ); ?></p>
												<?php } ?>
												</div>
											</div>
											<?php
											$x++;
										}
									}
								endif;
								?>
							</div>
						</div>
						<?php
					}
					?>
				</div>
			</div>
		</div>
	</div>
</section>
<?php
$opt = lifeline()->options();
if ( lifeline_get( $opt, 'join_us_section' ) ) :
	?>
	<section>
		<div class="pb-80 bg-gray position-relative w-100">
			<div class="container">
				<div class="join-team-wrap py-70 text-center w-100">
					<h2 class="mb-0 font-weight-semibold"><?php echo esc_html( lifeline_get( $opt, 'join_us_section_title' ) ); ?></h2>
					<p class="mb-0"><?php echo esc_html( lifeline_get( $opt, 'join_us_section_description' ) ); ?></p>
					<?php if ( lifeline_get( $opt, 'join_us_button' ) ) : ?>
						<a class="theme-btn bg-theme overflow-hidden mt-40 d-inline-block text-white position-relative rounded font-weight-bold" href="<?php echo esc_url( lifeline_get( $opt, 'join_us_section_link' ) ); ?>"><?php echo esc_html( lifeline_get( $opt, 'join_us_button_label' ) ); ?></a>
					<?php endif; ?>
				</div><!-- Join Team Wrap -->
			</div>
		</div>
	</section>
	<?php
endif;
get_footer();
