<?php
get_header();

while ( have_posts() ) {
	the_post();
	$meta    = lifeline()->page()->args;
	$layout  = lifeline_get( $meta, 'sidebar_position' );
	$sidebar = lifeline_get( $meta, 'sidebar', 'sidebar-1' );
	$col     = ( $layout != 'full' ) ? '9' : '12'; // phpcs:ignore WordPress
	$col     = apply_filters( 'lifeline/post/life_gallery/content/classes', "col-md-{$col} col-sm-12 col-lg-{$col}" );
	wp_enqueue_script( array( 'fancybox', 'isotope', 'isotope-init' ) );
	$meta       = lifeline()->meta( get_the_ID() );
	$meta_video = lifeline_get( $meta, 'lifeline_videos' );
	$meta_image = lifeline_get( $meta, 'lifeline_gal_ids' );
	?>
	<section>
		<div id="post-<?php the_ID(); ?>" <?php post_class( 'pt-80 pb-50 bg-gray position-relative w-100' ); ?>>
			<div class="container">
				<div class="row">
					<?php
					if ( $layout == 'left' ) : // phpcs:ignore WordPress
						// phpcs:ignore WordPress
						do_action( 'lifeline/post/sidebar', $sidebar );
					endif;
					?>
					<div class="<?php echo esc_attr( $col ); ?>">
						<?php if ( ! empty( $meta_video ) && ! empty( $meta_image ) ) : ?>
							<ul class="fltr-btns list-unstyled mb-50 d-flex justify-content-center text-center w-100">
								<li class="active text-uppercase text-white font-family-poppins font-weight-medium">
									<a class="d-block" data-filter="*" href="javascript:void(0);"><?php esc_html_e( 'ALL', 'lifeline' ); ?></a>
								</li>
								<li class="text-uppercase text-white font-family-poppins font-weight-medium">
									<a class="d-block" data-filter=".video" href="javascript:void(0);"><?php esc_html_e( 'Videos', 'lifeline' ); ?></a>
								</li>
								<li class="text-uppercase text-white font-family-poppins font-weight-medium">
									<a class="d-block" data-filter=".image" href="javascript:void(0);"><?php esc_html_e( 'Images', 'lifeline' ); ?></a>
								</li>
							</ul>
						<?php endif; ?>
						<div class="gallery-wrap w-100">
							<div class="row masonry">
								<?php
								get_template_part( 'templates/gallery/image' );
								get_template_part( 'templates/gallery/video' );
								?>
							</div>
						</div><!-- Gallery Wrap -->
					</div>
					<?php
					if ( $layout == 'right' ) : // phpcs:ignore WordPress
						// phpcs:ignore WordPress
						do_action( 'lifeline/post/sidebar', $sidebar );
					endif;
					?>
				</div>
			</div>
		</div>
	</section>
	<?php
}

get_footer();
