<?php
get_header();
$opt = lifeline()->options();
$meta = get_post_meta( get_the_ID() );

$style   = lifeline_get( $opt, 'event_detail_style' );
$show_detail   = lifeline_get( $opt, 'event_detail_show_event' );

$detail_label   = lifeline_get( $opt, 'event_detail_show_event_label' );

$register_btn   = lifeline_get( $opt, 'event_detail_show_register' );
$register_btn_label   = lifeline_get( $opt, 'event_detail_register_label' );
$form    = lifeline_get( $opt, 'news_form' );
$event_detail_register_link   = lifeline_get( $opt, 'event_detail_register_link' );

$meta     = lifeline()->meta( get_the_ID() );

$date_s   = lifeline_get( $meta, 'start_date' );

$date_e   = lifeline_get( $meta, 'end_dateee' );
$website  = lifeline_get( $meta, 'event_organizer_website' );
$number   = lifeline_get( $meta, 'event_organizer_number' );
$organization_img   = lifeline_get( $meta, 'organization_img' ) ? lifeline_get(lifeline_get( $meta, 'organization_img' ), 'id') : '';

$location = lifeline_get( $meta, 'location' );
$email = lifeline_get( $meta, 'emaill' );
$name     = lifeline_get( $meta, 'name' );

$meta    = lifeline()->page()->args;

$layout  = lifeline_get( $meta, 'sidebar_position', 'left' );
$sidebar = lifeline_get( $meta, 'sidebar', 'sidebar-1' );
$col     = ( $layout != 'full' ) ? '9' : '12'; // phpcs:ignore WordPress
$col     = apply_filters( 'lifeline/post/life_event/content/classes', "col-md-12 col-sm-12 col-lg-{$col}" );
?>
<section class="py-110">
	<div id="post-<?php the_ID(); ?>" <?php post_class( 'py-80 bg-gray position-relative w-100' ); ?>>
		<?php if ($style == 'event-detail1') : ?>
			<div class="container">
		<?php endif; ?>
		
			<div class="row">
				<?php
				if ( $layout == 'left' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				?>
				<div class="<?php echo esc_attr( $col ); ?>">
					

						<?php
						while ( have_posts() ) {
							the_post();
							?>

							 <?php lifeline_template_load( 'templates/event/'.$style.'.php', compact( 'detail_label','date_s', 'email', 'date_e', 'location', 'show_detail', 'name', 'number', 'opt', 'organization_img', 'website', 'register_btn', 'register_btn_label', 'form', 'style') ); ?>
							
							<?php
						} ?>
					
					</div>
				
				<?php
				if ( $layout == 'right' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				?>
			</div>
		<?php if ($style == 'event-detail') : ?>
			</div>
		<?php endif; ?>
	</div>
</section>
<?php
get_footer();
