<?php
get_header();
$opt = lifeline()->options();

$style = lifeline_get( $opt, 'blog_listing_style', 'list' );

$meta    = lifeline()->page()->args;
$layout  = ( lifeline_get( $meta, 'sidebar_position' ) != 'full' ) ? lifeline_get( $meta, 'sidebar_position' ) : ''; // phpcs:ignore WordPress
$sidebar = ( lifeline_get( $meta, 'sidebar' ) ) ? lifeline_get( $meta, 'sidebar' ) : '';
$col     = ( $layout != 'full' && $layout ) ? '9' : '12'; // phpcs:ignore WordPress
?>
<section>
	<div class="pt-80 pb-50 bg-gray position-relative w-100">
		<div class="container">
			<div class="row">
				<?php
				if ( $layout == 'left' && is_active_sidebar( $sidebar ) && $style != 'grid' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				?>
				<div class="col-lg-12">
					<h5 class="search-title"><?php esc_html_e( 'Related Search Result ', 'lifeline' ); ?><span>"<?php echo get_search_query(); ?>"</span></h5>
				</div>
				<?php
				if ( $style == 'list' ) : // phpcs:ignore WordPress
					?>
					<div class="col-md-12 col-sm-12 col-lg-<?php echo esc_attr( $col ); ?>">
					<?php
				endif;
				// phpcs:ignore WordPress
				get_template_part( "templates/blog/{$style}" );
				if ( $style == 'list' ) : // phpcs:ignore WordPress
					?>
					</div>
					<?php
				endif;

				if ( $layout == 'right' && is_active_sidebar( $sidebar ) && $style != 'grid' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				?>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
