<?php
get_header();
$opt = lifeline()->options();

$style = lifeline_get( $opt, 'blog_listing_style', 'list' );

$meta = lifeline()->page()->args;

// phpcs:ignore WordPress
$layout  = ( lifeline_get( $meta, 'sidebar_position' ) != 'full' && !empty( lifeline_get( $meta, 'sidebar_position' ) ) ) ? lifeline_get( $meta, 'sidebar_position' ) : '';
$sidebar = ( lifeline_get( $meta, 'sidebar' ) ) ? lifeline_get( $meta, 'sidebar' ) : '';

$col     = ( $layout != 'full' && $layout ) ? '9' : '10 mx-auto'; // phpcs:ignore WordPress
?>
<section class="py-110">
	<div <?php post_class( 'pt-80 pb-50 bg-gray position-relative w-100' ); ?>>
		<div class="container">
			<div class="row">
				<?php
				if ( $layout == 'left' && is_active_sidebar( $sidebar ) && $style != 'grid' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				if ( $style == 'list' || $style == 'list2'  || $style == 'list3'  ) : // phpcs:ignore WordPress
					?>
					<div class="col-md-12 col-sm-12 col-lg-<?php echo esc_attr( $col ); ?>">
					<?php
				endif;
				get_template_part( "templates/blog/{$style}" );
				if ( $style == 'list' || $style == 'list2'  || $style == 'list3' ) : // phpcs:ignore WordPress
					?>
					</div>
					<?php
				endif;
				if ( $layout == 'right' && is_active_sidebar( $sidebar ) && $style != 'grid' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				?>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
