<?php

/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */

namespace Lifeline\Helpers;

trait Common {


	protected $wp_template = 'page';

	private $args     = array(
		'sidebar'          => 'sidebar-1',
		'sidebar_position' => 'right',
		'enable_banner'    => false,
		'banner_title'     => '',
		'banner_desc'      => '',
		'banner_bg'        => '',
		'enable_bread'     => false,
		/* 'header_meta'      => false,
		'header_style'     => '1', */
	);
	private $meta_map = array(
		'sidebar'          => 'metaSidebar',
		'sidebar_position' => 'layout',
		'enable_banner'    => 'show_title_section',
		'banner_title'     => 'banner_title',
		'banner_bg'        => 'page_title_section_bg',
		'banner_desc'      => 'banner_desc',
		'enable_bread'     => 'banner_breadcrumb',
		/* 'header_meta'      => 'header_meta',
		'header_style'     => 'header_style', */
	);

	private $options_map = array(
		'sidebar'          => '{prefix}_sidebar',
		'sidebar_position' => '{prefix}_sidebar_layout',
		'enable_banner'    => '{prefix}_page_title_section',
		'banner_title'     => '{prefix}_page_title',
		'banner_bg'        => '{prefix}_title_section_bg',
		'banner_desc'      => '{prefix}_desc_section_bg',
		'enable_bread'     => '{prefix}_breadcrumbs',
		'sidebar'          => '{prefix}_sidebar',
		'sidebar_position' => '{prefix}_sidebar_layout',
	);

	private $blog_id;

	/**
	 *
	 */
	function setWpTemplate( $template ) { // phpcs:ignore WordPress
		$this->wp_template = $template;

		return $this;
	}

	function meta( $id = 0 ) {
		if ( ! $id ) {
			$id = get_the_id();
		}

		$meta = get_post_meta( $id );

		return $this->formatMeta( $meta );
	}

	function formatMeta( $meta ) { // phpcs:ignore WordPress
		$formatted = array();
		if ( ! $meta ) {
			return;
		}
		foreach ( $meta as $key => $mt ) {
			$formatted[ $key ] = maybe_unserialize( $mt[0] );
		}

		return $formatted;
	}

	function makeBannerData( $template = '' ) { // phpcs:ignore WordPress
		if ( is_callable( array( $this, $this->wp_template ), true ) ) {
			call_user_func( array( $this, $this->wp_template ) );
		}
		return $this;
	}

	function getBannerData() { // phpcs:ignore WordPress
		return $this->args;
	}

	/* function page() {
		$this->blog();
		$post_id = get_the_ID();
		if ( function_exists( 'is_shop' ) && is_shop() ) {
			$post_id = wc_get_page_id( 'shop' );
		}
		$this->singleMeta( $post_id );

		return $this;
	} */

	function singleMeta( $id = 0 ) { // phpcs:ignore WordPress
		if ( ! $id ) {
			$id = get_the_id();
		}

		$meta = $this->meta( $id );

		$this->mapMeta( $meta );

		if (get_post_type( $id ) == 'product') { // phpcs:ignore WordPress
			$desc                      = get_post_meta( $id, 'banner_excerpt', true );
			$this->args['banner_desc'] = ( $desc ) ? $desc : '';
		} else {
			$this->args['banner_desc'] = $this->excerpt( $id );
		}
	}

	function excerpt( $id = 0 ) {
		if ( ! has_excerpt() ) {
			return;
		}

		$output = str_replace( array( '<p>', '</p>' ), '', get_the_excerpt( $id ) );
		return $output;
	}

	/**
	 *
	 */
	function getArgs( $key = '' ) { // phpcs:ignore WordPress
		return lifeline_get( $this->args, $key );
	}

	/**
	 *
	 */
	function mapOptions( $map_key ) { // phpcs:ignore WordPress
		$options = lifeline()->options();

		array_map(
			function ( $key, $value ) use ( $options, $map_key ) {
				$value   = str_replace( '{prefix}', $map_key, $value );
				$new_val = lifeline_get( $options, $value );
				if ( $new_val ) {
					$this->args[ $key ] = $new_val;
				}
			},
			array_keys( $this->options_map ),
			array_values( $this->options_map )
		);
	}
	/**
	 *
	 */
	function mapMeta( $meta ) { // phpcs:ignore WordPress
		array_map(
			function ( $key, $value ) use ( $meta ) {
				$new_val = lifeline_get( $meta, $value );
				if ( $new_val ) {
					$this->args[ $key ] = $new_val;
				}
			},
			array_keys( $this->meta_map ),
			array_values( $this->meta_map )
		);
	}

	function page() {
		global $wp_query;
		if ( $wp_query->is_posts_page ) {
			$page_id = $wp_query->queried_object->ID;
		} else {
			$page_id = get_queried_object_id();
		}
		//printr( $wp_query );

		switch ( $wp_query ) {
			case lifeline_get( $wp_query, 'is_single' ) || lifeline_get( $wp_query, 'is_page' ) || lifeline_get( $wp_query, 'is_singular' ):
				if ( function_exists( 'is_shop' ) && is_shop() ) {
					$post_id = wc_get_page_id( 'shop' );
				}
				$this->singleMeta( $page_id );
				break;
			case lifeline_get( $wp_query, 'is_tag' ):
				$this->tag();
				break;
			case lifeline_get( $wp_query, 'is_author' ):
				$this->author();
				break;
			case lifeline_get( $wp_query, 'is_category' ):
				$this->category();
				break;
			case lifeline_get( $wp_query, 'is_search' ):
				$this->search();
				break;
			case lifeline_get( $wp_query, 'is_posts_page' ):
				$this->mapOptions( 'blog' );
				//print_r($this->mapOptions( 'blog' )); exit;
				$this->singleMeta( $page_id );
				break;
			case lifeline_get( $wp_query, 'is_post_type_archive' ):
				if ( function_exists( 'is_shop' ) && is_shop() ) {
					$page_id = wc_get_page_id( 'shop' );
					return call_user_func( array( $this, 'singleMeta' ), $page_id );
				}
				$type_name = str_replace( 'lif_', '', get_post_type() );
				call_user_func( array( $this, $type_name ) );
				break;
			case lifeline_get( $wp_query, 'is_tax' ):
				if ( function_exists( 'is_product_taxonomy' ) && is_product_taxonomy() ) {
					return call_user_func( array( $this, 'product_category' ) );
				}
				$tax_name = str_replace( 'lif_', '', get_post_type() ) . '_category';
				call_user_func( array( $this, $tax_name ) );
				break;
			default:
				$this->archive();

		}

		return $this;
	}

	function tag() {
		$this->mapOptions( 'tag' );
		$this->args['banner_title'] = esc_html( 'Tag: ', 'lifeline' ) . wp_title( '', false );
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function author() {
		$this->mapOptions( 'auth' );
		$this->args['banner_title'] = esc_html( 'Author: ', 'lifeline' ) . wp_title( '', false );
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function archive() {
		$this->mapOptions( 'archive' );
		$this->args['banner_title'] = esc_html( 'Archive: ', 'lifeline' ) . wp_title( '', false );
		return $this;
	}

	function category() {
		
		$this->mapOptions( 'cat' );
		$this->args['banner_title'] = esc_html( 'Category: ', 'lifeline' ) . wp_title( '', false );
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function search() {
		$this->mapOptions( 'search' );
		$this->args['banner_title'] = wp_title( '', false );
		return $this;
	}

	function project_category() {
		$this->mapOptions( 'project_cat' );
		$this->args['banner_title'] = esc_html( 'Category: ', 'lifeline' ) . get_queried_object()->name;
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function gallery_category() {
		$this->mapOptions( 'gallery_cat' );
		$this->args['banner_title'] = esc_html( 'Category: ', 'lifeline' ) . get_queried_object()->name;
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function cause_category() {
		$this->mapOptions( 'causes_cat' );
		$this->args['banner_title'] = esc_html( 'Category: ', 'lifeline' ) . get_queried_object()->name;
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function event_category() {
		$this->mapOptions( 'evant_cat' );
		$this->args['banner_title'] = esc_html( 'Category: ', 'lifeline' ) . get_queried_object()->name;
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function service_category() {
		$this->mapOptions( 'services_cat' );
		$this->args['banner_title'] = esc_html( 'Category: ', 'lifeline' ) . get_queried_object()->name;
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function team_category() {
		$this->mapOptions( 'team_cat' );
		$this->args['banner_title'] = esc_html( 'Category: ', 'lifeline' ) . get_queried_object()->name;
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function story_category() {
		$this->mapOptions( 'story_cat' );
		$this->args['banner_title'] = esc_html( 'Category: ', 'lifeline' ) . get_queried_object()->name;
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function product_category() {
		$page_id = wc_get_page_id( 'shop' );
		$this->singleMeta( $page_id );
		$this->args['banner_title'] = esc_html( 'Product: ', 'lifeline' ) . get_queried_object()->name;
		$this->args['banner_desc']  = str_replace( array( '<p>', '</p>' ), '', get_the_archive_description() );
		return $this;
	}

	function project() {
		$this->mapOptions( 'project_list' );
		return $this;
	}

	function gallery() {
		$this->mapOptions( 'gallery_list' );
		return $this;
	}

	function cause() {
		$this->mapOptions( 'causes_list' );
		return $this;
	}

	function event() {
		$this->mapOptions( 'evant_list' );
		return $this;
	}

	function service() {
		$this->mapOptions( 'services_list' );
		return $this;
	}

	function team() {
		$this->mapOptions( 'team_list' );
		return $this;
	}

	function story() {
		$this->mapOptions( 'story_list' );
		return $this;
	}
}
