<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.5
 */
namespace Lifeline\Classes;

class PageLoader {

	/**
	 * boot
	 *
	 * @return void
	 */
	public static function boot() {
		add_action( 'wp_body_open', array( __CLASS__, 'loader_func' ), 0 );
	}

	/**
	 * loader_func
	 *
	 * @return void
	 */
	public static function loader_func() {
		$options = lifeline()->options();
		if ( ! lifeline_get( $options, 'theme_preloader' ) ) {
			return;
		}
		$style = str_replace( '-', '_', lifeline_get( $options, 'theme_preloader_style', 'ball-pulse' ) );
		if ( $style && method_exists( __CLASS__, $style ) ) {
			call_user_func( array( __CLASS__, $style ) );
		}
	}

	/**
	 * ball_pulse
	 *
	 * @return void
	 */
	public static function ball_pulse() {
		?>
		<div class="loader">
			<div class="loader-inner ball-pulse">
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_grid_pulse
	 *
	 * @return void
	 */
	public static function ball_grid_pulse() {
		?>
		<div class="loader">
			<div class="loader-inner ball-grid-pulse">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_grid_beat
	 *
	 * @return void
	 */
	public static function ball_grid_beat() {
		?>
		<div class="loader">
			<div class="ball-grid-beat"><div>
			</div>
			<div>
			</div
			><div>
			</div>
			<div>
			</div>
			<div>
			</div>
			<div>
			</div>
			<div>
			</div>
			<div></div>
			<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_spin_fade_loader
	 *
	 * @return void
	 */
	public static function ball_spin_fade_loader() {
		?>
		<div class="loader"><div class="ball-spin-fade-loader"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div></div>
		<?php
	}

	/**
	 * ball_clip_rotate
	 *
	 * @return void
	 */
	public static function ball_clip_rotate() {
		?>
		<div class="loader">
			<div class="loader-inner ball-clip-rotate">
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_clip_rotate_pulse
	 *
	 * @return void
	 */
	public static function ball_clip_rotate_pulse() {
		?>
		<div class="loader">
			<div class="loader-inner ball-clip-rotate-pulse">
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_clip_rotate_multiple
	 *
	 * @return void
	 */
	public static function ball_clip_rotate_multiple() {
		?>
		<div class="loader">
			<div class="loader-inner ball-clip-rotate-multiple">
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_pulse_rise
	 *
	 * @return void
	 */
	public static function ball_pulse_rise() {
		?>
		<div class="loader">
			<div class="loader-inner ball-pulse-rise">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_rotate
	 *
	 * @return void
	 */
	public static function ball_rotate() {
		?>
		<div class="loader">
			<div class="loader-inner ball-rotate">
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_zig_zag
	 *
	 * @return void
	 */
	public static function ball_zig_zag() {
		?>
		<div class="loader">
			<div class="loader-inner ball-zig-zag">
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_zig_zag_deflect
	 *
	 * @return void
	 */
	public static function ball_zig_zag_deflect() {
		?>
		<div class="loader">
			<div class="loader-inner ball-zig-zag-deflect">
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_triangle_path
	 *
	 * @return void
	 */
	public static function ball_triangle_path() {
		?>
		<div class="loader">
			<div class="loader-inner ball-triangle-path">
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_scale
	 *
	 * @return void
	 */
	public static function ball_scale() {
		?>
		<div class="loader">
			<div class="loader-inner ball-scale">
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_scale_multiple
	 *
	 * @return void
	 */
	public static function ball_scale_multiple() {
		?>
		<div class="loader">
			<div class="loader-inner ball-scale-multiple">
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_pulse_sync
	 *
	 * @return void
	 */
	public static function ball_pulse_sync() {
		?>
		<div class="loader">
			<div class="loader-inner ball-pulse-sync">
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_beat
	 *
	 * @return void
	 */
	public static function ball_beat() {
		?>
		<div class="loader">
			<div class="loader-inner ball-beat">
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_scale_ripple
	 *
	 * @return void
	 */
	public static function ball_scale_ripple() {
		?>
		<div class="loader">
			<div class="loader-inner ball-scale-ripple">
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ball_scale_ripple_multiple
	 *
	 * @return void
	 */
	public static function ball_scale_ripple_multiple() {
		?>
		<div class="loader">
			<div class="loader-inner ball-scale-ripple-multiple">
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * cube_transition
	 *
	 * @return void
	 */
	public static function cube_transition() {
		?>
		<div class="loader">
			<div class="loader-inner cube-transition">
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * circle
	 *
	 * @return void
	 */
	public static function circle() {
		?>
		<div class="loader">
			<div class="lds-circle"></div>
		</div>
		<?php
	}

	/**
	 * dual_ring
	 *
	 * @return void
	 */
	public static function dual_ring() {
		?>
		<div class="loader">
			<div class="lds-dual-ring"></div>
		</div>
		<?php
	}

	/**
	 * line_scale
	 *
	 * @return void
	 */
	public static function line_scale() {
		?>
		<div class="loader">
			<div class="loader-inner line-scale">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * line_scale_party
	 *
	 * @return void
	 */
	public static function line_scale_party() {
		?>
		<div class="loader">
			<div class="loader-inner line-scale-party">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * line_scale_multiple
	 *
	 * @return void
	 */
	public static function line_scale_multiple() {
		?>
		<div class="loader">
			<div class="loader-inner ball-scale-multiple">
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * line_scale_pulse_out
	 *
	 * @return void
	 */
	public static function line_scale_pulse_out() {
		?>
		<div class="loader">
			<div class="loader-inner line-scale-pulse-out">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * line_scale_pulse_out_rapid
	 *
	 * @return void
	 */
	public static function line_scale_pulse_out_rapid() {
		?>
		<div class="loader">
			<div class="loader-inner line-scale-pulse-out-rapid">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * line_spin_fade_loader
	 *
	 * @return void
	 */
	public static function line_spin_fade_loader() {
		?>
		<div class="loader">
			<div class="loader-inner line-spin-fade-loader">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ellipsis
	 *
	 * @return void
	 */
	public static function ellipsis() {
		?>
		<div class="loader">
			<div class="lds-ellipsis">
				<div></div>
				<div></div>
				<div></div>
				</div>
			</div>
		</div>
		<?php
	}

	/**
	 * facebook
	 *
	 * @return void
	 */
	public static function facebook() {
		?>
		<div class="loader">
			<div class="lds-facebook">
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * full_ring
	 *
	 * @return void
	 */
	public static function full_ring() {
		?>
		<div class="loader">
			<div class="lds-full-ring">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * grid
	 *
	 * @return void
	 */
	public static function grid() {
		?>
		<div class="loader">
			<div class="lds-grid">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * heart
	 *
	 * @return void
	 */
	public static function heart() {
		?>
		<div class="loader">
			<div class="lds-heart">
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * hourglass
	 *
	 * @return void
	 */
	public static function hourglass() {
		?>
		<div class="loader">
			<div class="lds-hourglass"></div>
		</div>
		<?php
	}

	/**
	 * pacman
	 *
	 * @return void
	 */
	public static function pacman() {
		?>
		<div class="loader">
			<div class="loader-inner pacman">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ring
	 *
	 * @return void
	 */
	public static function ring() {
		?>
		<div class="loader">
			<div class="lds-ring">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * roller
	 *
	 * @return void
	 */
	public static function roller() {
		?>
		<div class="loader">
			<div class="lds-roller">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * ripple
	 *
	 * @return void
	 */
	public static function ripple() {
		?>
		<div class="loader">
			<div class="lds-ripple">
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * square_spin
	 *
	 * @return void
	 */
	public static function square_spin() {
		?>
		<div class="loader">
			<div class="loader-inner square-spin">
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * semi_circle_spin
	 *
	 * @return void
	 */
	public static function semi_circle_spin() {
		?>
		<div class="loader">
			<div class="loader-inner semi-circle-spin">
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * spinner
	 *
	 * @return void
	 */
	public static function spinner() {
		?>
		<div class="loader">
			<div class="lds-spinner">
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
				<div></div>
			</div>
		</div>
		<?php
	}

	/**
	 * triangle_skew_spin
	 *
	 * @return void
	 */
	public static function triangle_skew_spin() {
		?>
		<div class="loader">
			<div class="loader-inner triangle-skew-spin">
				<div></div>
			</div>
		</div>
		<?php
	}
}
