<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */
namespace Lifeline\Classes;

use Lifeline\Classes\Arr;
use Lifeline\Helpers\Facade;
use Lifeline\Helpers\Common;

class Lifeline {

	use Common;

	static $instance;


	/**
	 * instance
	 *
	 * @return void
	 */
	static function instance() {
		if ( self::$instance == null ) { // phpcs:ignore WordPress
			self::$instance = new self;
		}

		return self::$instance;
	}

	/**
	 * [classes description]
	 * @return [type] [description]
	 */
	function classes() {
		return array(
			'array' => \Lifeline\Classes\Arr::class,
			'demos' => \Lifeline\Classes\Demos::class,
		);
	}
	/**
	 * Theme Options
	 * @param  string $key [description]
	 * @return [type]      [description]
	 */
	function options( $key = '' ) {
		global $lifeline_theme_options;

		if ( ! $lifeline_theme_options ) {
			$lifeline_theme_options = get_option( 'lifeline_theme_options' );
		}

		if ( $key ) {
			return Arr::get( $lifeline_theme_options, $key );
		}

		return $lifeline_theme_options;
	}

	/**
	 * __get
	 *
	 * @param  mixed $name
	 * @return void
	 */
	public function __get( $name ) {
		if ( property_exists( $this, $name ) ) {
			return $this->$name;
		} else {
			$classes = $this->classes();
			$class   = isset( $classes[ $name ] ) ? $classes[ $name ] : '';

			if ( $class && class_exists( $class ) ) {
				return new $class;
			}
		}
	}

	/**
	 * meta
	 *
	 * @param  mixed $id
	 * @return void
	 */
	function meta( $id = 0 ) {
		if ( ! $id ) {
			$id = get_the_id();
		}

		$meta = get_post_meta( $id );

		return $this->formatMeta( $meta );
	}

	/**
	 * formatMeta
	 *
	 * @param  mixed $meta
	 * @return void
	 */
	function formatMeta( $meta ) { // phpcs:ignore WordPress
		$formatted = array();
		if ( ! $meta ) {
			return;
		}
		foreach ( $meta as $key => $mt ) {
			$formatted[ $key ] = maybe_unserialize( $mt[0] );
		}

		return $formatted;
	}
}
