<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */
namespace Lifeline\Classes;

use Lifeline\Helpers\Common;

class Header {

	use Common;

	public $page = 'page';

	/**
	 * make
	 *
	 * @param  mixed $page
	 * @return void
	 */
	function make( $page = 'blog' ) {
		$this->page = $page;

		$method = 'header' . ucwords( $page );

		if ( method_exists( $this, $method ) ) {
			call_user_func( array( $this, $method ) );
		}
	}

	/**
	 * header
	 *
	 * @return void
	 */
	function header() {
		$post_id = get_the_ID();
		$options = lifeline()->options();
		$meta    = lifeline()->meta($post_id);

		// Theme options
		$hdr_src_opt_type = lifeline_get($options, 'header_src_type', 'default');
		$hdr_tmp_opt_id   = lifeline_get($options, 'header_elementor_template');
		$hdr_opt_style    = lifeline_get($options, 'header_styles', 1);

		// Meta values
		$header_meta         = lifeline_get($meta, 'header_meta', false);
		$header_source_type  = lifeline_get($meta, 'header_src_type', $hdr_src_opt_type);
		$meta_temp_id        = lifeline_get($meta, 'header_elementor_template', $hdr_tmp_opt_id);
		$meta_header_style   = lifeline_get($meta, 'header_style', $hdr_opt_style);

		// Check if meta header is set and use it
		if ($header_meta) {
			if ('default' != $header_source_type && class_exists('\Elementor\Plugin') && $meta_temp_id) {
				echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display($meta_temp_id);
				return;
			}
			get_template_part('templates/header/header-style', $meta_header_style);
			return;
		}

		// Fallback to theme options
		if ('default' != $hdr_src_opt_type && class_exists('\Elementor\Plugin') && $hdr_tmp_opt_id) {
			echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display($hdr_tmp_opt_id);
			return;
		}
		get_template_part('templates/header/header-style', $hdr_opt_style);

		if (lifeline_get($options, 'header_sticky')) {
			wp_enqueue_script('scroll-up-bar');
		}
	}

	/**
	 * banner
	 *
	 * @param  mixed $template
	 * @param  string $style
	 * @return void
	 */
	function banner($template, $style = '1') {
		$this->wp_template = $template;
		$this->makeBannerData();
		extract($this->getBannerData()); // phpcs:ignore WordPress
		include get_theme_file_path("templates/page-banner/banner-style-{$style}.php");
	}
}