<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */
namespace Lifeline\Classes;

use Lifeline\Plugin\lifeline_Resizer;

class Ajax {

	/**
	 * actions
	 *
	 * @return void
	 */
	function actions() {
		add_action( 'wp_ajax_lifeline_ajax', array( $this, 'ajax_handler' ) );
		add_action( 'wp_ajax_nopriv_lifeline_ajax', array( $this, 'ajax_handler' ) );
	}
	function ajax_handler() {
		$method = lifeline_get( $_REQUEST, 'subaction' );
		if ( method_exists( $this, $method ) ) {
			$this->$method();
		}
		exit;
	}

	/**
	 * twitter
	 *
	 * @param  mixed $args
	 * @return void
	 */
	public static function twitter( $args = array() ) {
		$selector = lifeline_get( $args, 'selector' );
		$temp     = lifeline_get( $args, 'template', 'blockquote' );
		$count    = lifeline_get( $args, 'count', 3 );
		$screen   = lifeline_get( $args, 'screen_name', 'WordPress' );
		$options  = array(
			'template'    => $temp,
			'count'       => $count,
			'screen_name' => $screen,
		);
		$script   = 'jQuery(document).ready(function($){$("' . $selector . '").tweets(' . json_encode( $options ) . ');});';
		wp_add_inline_script( 'lifeline-script', $script );
	}

	/**
	 * twitter_callback
	 *
	 * @return void
	 */
	public function twitter_callback() {
		$opt       = lifeline()->options();
		$api       = lifeline_get( $opt, 'twitter_api' );
		$api_sec   = lifeline_get( $opt, 'twitter_api_secret' );
		$token     = lifeline_get( $opt, 'twitter_token' );
		$token_sec = lifeline_get( $opt, 'twitter_token_Secret' );

		if ( ! $api || ! $api_sec || ! $token || ! $token_sec ) {
			return;
		}

		\Lifeline\Plugin\Libraries\Codebird::setConsumerKey( $api, $api_sec );
		$cb = \Lifeline\Plugin\Libraries\Codebird::getInstance();
		$cb->setToken( $token, $token_sec );

		$params = array(
			'screen_name'         => lifeline_get( $_POST, 'screen_name' ),
			'count'               => lifeline_get( $_POST, 'count' ),
			'exclude_replies'     => 0,
			'include_rts'         => 0,
			'include_entities'    => 0,
			'trim_user'           => false,
			'contributor_details' => false,
		);
		$reply  = $cb->statuses_userTimeline( $params );
		unset( $reply->httpstatus );
		echo json_encode( $reply );
		exit;
	}

	/**
	 * press_room
	 *
	 * @return void
	 */
	public function press_room() {
		$query          = lifeline_get( $_POST, 'data' );
		$query          = lifeline_dencrypt( $query, true );
		$query['paged'] = $query['paged'] + 1;
		$title_limit    = lifeline_get( $query, 'title_limit' );
		$desc_limit     = lifeline_get( $query, 'desc_limit' );

		$post  = new \WP_Query( $query );
		$query = lifeline_encrypt( $query );
		ob_start();
		while ( $post->have_posts() ) :
			$post->the_post();
			?>
			<div class="blog-list align-items-center mt-30 rounded flex-wrap d-flex overflow-hidden">
				<div class="blog-list-thumb overflow-hidden position-relative">
					<?php the_post_thumbnail( '570x370', array( 'class' => 'img-fluid w-100' ) ); ?>
					<a class="theme-btn d-inline-block bg-theme overflow-hidden text-white rounded font-weight-bold center-content position-absolute" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'READ MORE', 'lifeline-plugin' ); ?></a>
					<span class="d-block text-white position-absolute bg-theme overflow-hidden">
						<i class="far fa-calendar bg-white"></i><?php echo get_the_date(); ?>
					</span>
				</div>
				<div class="blog-list-info">
					<h3 class="mb-0 font-weight-semibold text-dark ml-auto mr-auto d-inline-block">
						<a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php echo wp_trim_words( get_the_title(), $title_limit, '' ); ?></a>
					</h3>
					<ul class="mb-0 blog-meta d-flex list-unstyled">
						<li class="font-family-poppins text-body">
							<i class="text-theme far fa-user"></i>
							<?php esc_html_e( 'By', 'lifeline-plugin' ); ?>
							<?php echo get_the_author(); ?>
						</li>
						<li class="font-family-poppins text-body"><i class="text-theme fas fa-align-justify"></i>
							<?php the_category( ', ' ); ?>
						</li>
					</ul>
					<p class="mb-0"><?php echo wp_trim_words( get_the_content(), $desc_limit, '' ); ?></p>
				</div>
			</div>
			<?php
		endwhile;
		wp_reset_postdata();
		$post = ob_get_clean();
		ob_start();
		?>
		<a id="press_room" class="load-more d-inline-block w-100 rounded text-center font-weight-extrabold mt-30" href="javascript:void(0);" data-load="<?php echo esc_attr( $query ); ?>">
			<i class="fas fa-sync"></i>
			<?php esc_html_e( 'LOAD MORE', 'lifeline-plugin' ); ?>
		</a>
		<?php
		$link = ob_get_clean();
		wp_send_json_success(
			array(
				'post'   => $post,
				'button' => $link,
			)
		);
	}

	public function lif_team_categories() {
		$category = lifeline_get( $_POST, 'data' );
		$title_limit    = lifeline_get( $_POST, 'title' );
		$query = new \WP_Query(
			array(
				'post_type' => 'lif_team',
				'status' => 'publish',
				'tax_query' => array(
					array(
						'taxonomy' => 'team_category',
						'field'    => 'slug',
						'terms'    => (array) $category,
					),
				),
			)
		);
		if( $query->have_posts() ) :
			ob_start();
			while( $query->have_posts() ) :
				$query->the_post();
				$meta = lifeline()->meta( get_the_id() );
	            $designation = lifeline_get( $meta, 'designation' );
	            $location    = lifeline_get( $meta, 'address' );
	            if (class_exists('lifeline_Resizer')) {
					$img_obj = new \lifeline_Resizer();
				}
		?>
			<div class="col-md-6">
                <div class="lif-team-item" data-title="<?php echo $title_limit ?>">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="lif-team-meta">
                                <figure>    
                                    <?php if (class_exists('Lifeline_Resizer')): ?>
                                        <?php echo wp_kses_post($img_obj->lifeline_resize(wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()), 'full'), 270, 280, true)); ?>
                                    <?php else: ?>
                                        <?php the_post_thumbnail('full'); ?>
                                    <?php endif; ?>
                                </figure>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="lif-team-content">
                                <h3>
                                    <a href="<?php the_permalink(); ?>">
                                        <?php
                                            if ( ! empty(  $title_limit  )  ) {
                                                echo wp_trim_words( get_the_title(), $title_limit );
                                            } else {
                                                echo get_the_title();
                                            }
                                        ?>
                                    </a>
                                </h3>
                                <div class="lif-team-meta">
                                    <span><?php echo esc_html__( $designation, 'lifeline' ); ?></span>
                                    <span><?php echo esc_html__( $location, 'lifeline' ); ?></span>
                                </div>
                                <?php 
                                $profile = lifeline_get( $meta, 'team_social_media' ); 
                                if ( $profile ) :
                                    ?>
                                    <div class="center-content position-absolute team-social">
                                        <div class="team-social-heading">
                                            <span><?php echo esc_html__( 'Fellows Program', 'lifeline' ); ?></span>
                                        </div>
                                        <?php
                                        foreach ( $profile['redux_repeater_data'] as $k => $v ) {
                                            $icon         = $profile['icon'][ $k ];
                                            $link         = $profile['link'][ $k ];
                                            $ibg_colorcon = $profile['bg_color'][ $k ]['color'];
                                            $text_color   = $profile['text_color'][ $k ]['color'];
                                            ?>
                                            <a style="color:<?php echo $text_color; ?>; background-color:<?php echo $ibg_colorcon; ?>" class="d-inline-block position-relative" href="<?php echo esc_url( $link ); ?>" title="<?php echo esc_attr( str_replace( array( 'fab fa-', '-' ), array( '', ' ' ), $icon ) ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
			endwhile; wp_reset_postdata();
			$post = ob_get_clean();
		endif;

		wp_send_json_success(
			array(
				'post'   => $post,
			)
		);
	}

	public function lif_team_regions() {
		$region = lifeline_get( $_POST, 'data' );
		$title_limit    = lifeline_get( $_POST, 'title' );
		$query = new \WP_Query(
			array(
				'post_type' => 'lif_team',
				'status' => 'publish',
				'tax_query' => array(
					array(
						'taxonomy' => 'team_region',
						'field'    => 'slug',
						'terms'    => (array) $region,
					),
				),
			)
		);
		if( $query->have_posts() ) :
			ob_start();
			while( $query->have_posts() ) :
				$query->the_post();
				$meta = lifeline()->meta( get_the_id() );
	            $designation = lifeline_get( $meta, 'designation' );
	            $location    = lifeline_get( $meta, 'address' );
	            if (class_exists('lifeline_Resizer')) {
					$img_obj = new \lifeline_Resizer();
				}
		?>
			<div class="col-md-6">
                <div class="lif-team-item" data-title="<?php echo $title_limit ?>">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="lif-team-meta">
                                <figure>    
                                    <?php if (class_exists('Lifeline_Resizer')): ?>
                                        <?php echo wp_kses_post($img_obj->lifeline_resize(wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()), 'full'), 270, 280, true)); ?>
                                    <?php else: ?>
                                        <?php the_post_thumbnail('full'); ?>
                                    <?php endif; ?>
                                </figure>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="lif-team-content">
                                <h3>
                                    <a href="<?php the_permalink(); ?>">
                                        <?php
                                            if ( ! empty(  $title_limit  )  ) {
                                                echo wp_trim_words( get_the_title(), $title_limit );
                                            } else {
                                                echo get_the_title();
                                            }
                                        ?>
                                    </a>
                                </h3>
                                <div class="lif-team-meta">
                                    <span><?php echo esc_html__( $designation, 'lifeline' ); ?></span>
                                    <span><?php echo esc_html__( $location, 'lifeline' ); ?></span>
                                </div>
                                <?php 
                                $profile = lifeline_get( $meta, 'team_social_media' ); 
                                if ( $profile ) :
                                    ?>
                                    <div class="center-content team-social">
                                        <div class="team-social-heading">
                                            <span><?php echo esc_html__( 'Fellows Program', 'lifeline' ); ?></span>
                                        </div>
                                        <?php
                                        foreach ( $profile['redux_repeater_data'] as $k => $v ) {
                                            $icon         = $profile['icon'][ $k ];
                                            $link         = $profile['link'][ $k ];
                                            $ibg_colorcon = $profile['bg_color'][ $k ]['color'];
                                            $text_color   = $profile['text_color'][ $k ]['color'];
                                            ?>
                                            <a style="color:<?php echo $text_color; ?>; background-color:<?php echo $ibg_colorcon; ?>" class="d-inline-block position-relative" href="<?php echo esc_url( $link ); ?>" title="<?php echo esc_attr( str_replace( array( 'fab fa-', '-' ), array( '', ' ' ), $icon ) ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
			endwhile; wp_reset_postdata();
			$post = ob_get_clean();
		endif;

		wp_send_json_success(
			array(
				'post'   => $post,
			)
		);
	}

	public function lif_team_names() {
		$name = lifeline_get( $_POST, 'data' );
		$title_limit    = lifeline_get( $_POST, 'title' );

		// print_r( $_POST['data'] );
		// exit( 'ss' );

		$query = new \WP_Query(
			array(
				'post_type' => 'lif_team',
				'post_status' => 'publish',
				's' => $_POST['data'],
			)
		);
		if( $query->have_posts() ) :
			ob_start();
			while( $query->have_posts() ) :
				$query->the_post();
				$meta = lifeline()->meta( get_the_id() );
	            $designation = lifeline_get( $meta, 'designation' );
	            $location    = lifeline_get( $meta, 'address' );
	            if (class_exists('lifeline_Resizer')) {
					$img_obj = new \lifeline_Resizer();
				}
				$main_title = strtolower( get_the_title() );
				$search_string = strtolower( $_POST['data'] );				
		?>
			<?php if ( strpos( $main_title, $search_string ) !== false ) : ?>
				<div class="col-md-6">
	                <div class="lif-team-item" data-title="<?php echo $title_limit ?>">
	                    <div class="row align-items-center">
	                        <div class="col-md-6">
	                            <div class="lif-team-meta">
	                                <figure>    
	                                    <?php if (class_exists('Lifeline_Resizer')): ?>
	                                        <?php echo wp_kses_post($img_obj->lifeline_resize(wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()), 'full'), 270,280, true)); ?>
	                                    <?php else: ?>
	                                        <?php the_post_thumbnail('full'); ?>
	                                    <?php endif; ?>
	                                </figure>
	                            </div>
	                        </div>
	                        <div class="col-md-6">
	                            <div class="lif-team-content">
	                                <h3>
	                                    <a href="<?php the_permalink(); ?>">
	                                        <?php
	                                            if ( ! empty(  $title_limit  )  ) {
	                                                echo wp_trim_words( get_the_title(), $title_limit );
	                                            } else {
	                                                echo get_the_title();
	                                            }
	                                        ?>
	                                    </a>
	                                </h3>
	                                <div class="lif-team-meta">
	                                    <span><?php echo esc_html__( $designation, 'lifeline' ); ?></span>
	                                    <span><?php echo esc_html__( $location, 'lifeline' ); ?></span>
	                                </div>
	                                <?php 
	                                $profile = lifeline_get( $meta, 'team_social_media' ); 
	                                if ( $profile ) :
	                                    ?>
	                                    <div class="center-content team-social">
	                                        <div class="team-social-heading">
	                                            <span><?php echo esc_html__( 'Fellows Program', 'lifeline' ); ?></span>
	                                        </div>
	                                        <?php
	                                        foreach ( $profile['redux_repeater_data'] as $k => $v ) {
	                                            $icon         = $profile['icon'][ $k ];
	                                            $link         = $profile['link'][ $k ];
	                                            $ibg_colorcon = $profile['bg_color'][ $k ]['color'];
	                                            $text_color   = $profile['text_color'][ $k ]['color'];
	                                            ?>
	                                            <a style="color:<?php echo $text_color; ?>; background-color:<?php echo $ibg_colorcon; ?>" class="d-inline-block position-relative" href="<?php echo esc_url( $link ); ?>" title="<?php echo esc_attr( str_replace( array( 'fab fa-', '-' ), array( '', ' ' ), $icon ) ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></a>
	                                            <?php
	                                        }
	                                        ?>
	                                    </div>
	                                <?php endif; ?>
	                            </div>
	                        </div>
	                    </div>
	                </div>
	            </div>
	        <?php endif; ?>
		<?php
			endwhile; wp_reset_postdata();
			$post = ob_get_clean();
		endif;

		wp_send_json_success(
			array(
				'post'   => $post,
			)
		);
	}

}
