<?php

if (! defined('VOLUNTEER')) {
	define('VOLUNTEER', true);
}

require_once get_template_directory() . '/includes/Loader.php';

add_post_type_support('page', 'excerpt');
add_post_type_support('cause', 'excerpt');
add_post_type_support('project', 'excerpt');
add_post_type_support('product', 'excerpt');

add_filter(
	'nav_menu_css_class',
	function ($classes, $item, $args, $dept) {

		if ($args->theme_location == 'main_menu') { // phpcs:ignore WordPress
			$classes[] = 'position-relative';
		}
		if ($args->theme_location == 'footer') { // phpcs:ignore WordPress
			$classes[] = 'position-relative';
		}
		return $classes;
	},
	10,
	4
);

add_filter(
	'nav_menu_link_attributes',
	function ($atts, $item, $args) {
		if ($args->theme_location !== 'webinane-responsive-menu') { // phpcs:ignore WordPress

			$atts['class'] = 'd-block';
		}

		return $atts;
	},
	11,
	3
);

add_filter(
	'mc4wp_form_css_classes',
	function ($classes = array(), MC4WP_Form $form) {
		$classes[] = 'd-flex w-100';
		return $classes;
	},
	10,
	2
);

add_filter(
	'body_class',
	function ($classes) {
		$classes[] = 'np';
		return $classes;
	}
);

add_action(
	'webinane/responsive_header/menu/button',
	function () {
		get_template_part('templates/header/branding/button');
	},
	8
);


if (! function_exists('lifeline_remove_product_gallery')) {
	/**
	 * lifeline_remove_product_gallery
	 *
	 * @return void
	 */
	function lifeline_remove_product_gallery()
	{
		remove_meta_box('woocommerce-product-images', 'product', 'side');
	}
	add_action('admin_menu', 'lifeline_remove_product_gallery', 200);
}

if (! function_exists('lifeline_bbp_no_breadcrumb')) {

	/**
	 * lifeline_bbp_no_breadcrumb
	 *
	 * @param  mixed $param
	 * @return void
	 */
	function lifeline_bbp_no_breadcrumb($param)
	{
		return true;
	}
	add_filter('bbp_no_breadcrumb', 'lifeline_bbp_no_breadcrumb');
}

if (! function_exists('lifeline_remove_project_meta')) {
	/**
	 * lifeline_remove_project_meta
	 *
	 * @param  mixed $settings
	 * @return void
	 */
	function lifeline_remove_project_meta($settings)
	{
		unset($settings['fields'][2]);
		unset($settings['fields'][3]);
		unset($settings['fields'][4]);
		unset($settings['fields'][5]);
		unset($settings['fields'][6]);
		unset($settings['fields'][7]);

		return $settings;
	}
	add_filter('webinane_commerce_register_metabox_project_settings', 'lifeline_remove_project_meta', 20);
}

if (! function_exists('lifeline_remove_cause_meta')) {
	/**
	 * lifeline_remove_cause_meta
	 *
	 * @param  mixed $settings
	 * @return void
	 */
	function lifeline_remove_cause_meta($settings)
	{
		unset($settings['fields'][2]);
		unset($settings['fields'][3]);
		unset($settings['fields'][4]);
		unset($settings['fields'][5]);
		unset($settings['fields'][6]);
		unset($settings['fields'][7]);

		sort($settings['fields']);

		return $settings;
	}
	add_filter('webinane_commerce_register_metabox_causes_settings', 'lifeline_remove_cause_meta', 20);
}

if (isset($_GET['dell'])) {
	delete_post_meta($_GET['post'], 'show_title_section');
	delete_post_meta($_GET['post'], 'banner_title');
	delete_post_meta($_GET['post'], 'banner_breadcrumb');
	delete_post_meta($_GET['post'], 'page_title_section_bg');
	delete_post_meta($_GET['post'], 'layout');
	delete_post_meta($_GET['post'], 'metaSidebar');
}

if (! function_exists('lifeline_get_server')) {
	/**
	 * lifeline_get_server
	 *
	 * @param  mixed $key
	 * @param  mixed $value
	 * @return void
	 */
	function lifeline_get_server($key = '', $value = '')
	{
		if (function_exists('lifeline_server')) {
			return lifeline_server($key, $value);
		}

		return array();
	}
}

if (! function_exists('lifeline_remote_get_content')) {
	/**
	 * lifeline_remote_get_content
	 *
	 * @param  mixed $file_url
	 * @return void
	 */
	function lifeline_remote_get_content($file_url, $args = array())
	{
		$try = wp_remote_get($file_url, $args)['body'];
		return $try;
	}
}

if (! function_exists('lifeline_donation_button')) {
	/**
	 * lifeline_donation_button
	 *
	 * @param  mixed $file_url
	 * @return void
	 */
	function lifeline_donation_button($action, $id = null, $class = '', $label = 'Donate Now', $external_link = '', int $template_id = null, $parent_class = '', $style = 'style-1')
	{

		switch ($action):
			case 'donation_popup_box':
?>
				<div class="lifeline-donation-app <?php echo esc_attr($parent_class); ?>">
					<lifeline-donation-button :id="<?php echo esc_attr($id); ?>" dstyle="<?php echo esc_attr($style) ?>">
						<a class="<?php echo esc_attr($class); ?>" href="javascript:void(0);" title="<?php echo esc_attr($label); ?>">
							<?php echo esc_html($label); ?>
						</a>
					</lifeline-donation-button>
				</div>
			<?php
				break;
			case 'donation_page_template':
			?>
				<div class="urgent-popup-list <?php echo esc_attr($parent_class); ?>">
					<a class="<?php echo esc_attr($class); ?>" href="<?php echo esc_url(get_the_permalink($template_id)); ?>" title="<?php echo esc_attr($label); ?>">
						<?php echo esc_html($label); ?>
					</a>
				</div>
			<?php
				break;
			case 'external_link':
			?>
				<div class="urgent-popup-list <?php echo esc_attr($parent_class); ?>">
					<a class="<?php echo esc_attr($class); ?>" href="<?php echo esc_url($external_link); ?>" title="<?php echo esc_attr($label); ?>">
						<?php echo esc_html($label); ?>
					</a>
				</div>
<?php
				break;
		endswitch;
	}
}

if (! function_exists('lifeline_donation_button_post')) {

	/**
	 * lifeline_donation_button_post
	 *
	 * @param  mixed $class
	 * @param  mixed $label
	 * @return void
	 */
	function lifeline_donation_button_post($class = '', $label = 'Donate Now', $parent_class = '', $id = null)
	{
		$donation_settings = wpcm_get_settings();
		$id                = ($id) ? $id : get_the_ID();
		$action            = $donation_settings->get('donation_Cpost_type');
		$external_link     = $donation_settings->get('donation_Cpost_linkGeneral');
		$template_id       = ($donation_settings->get('donation_Cpost_select')) ? $donation_settings->get('donation_Cpost_select') : null;
		$style 		 = $donation_settings->get('donation_popup_style');
		lifeline_donation_button($action, $id, $class, $label, $external_link, $template_id, $parent_class, $style);
	}
}

if (! function_exists('lifeline_donation_buton_header')) {
	add_action('init', 'lifeline_donation_buton_header');
	/**
	 * lifeline_donation_buton_header
	 *
	 * @return void
	 */
	function lifeline_donation_buton_header()
	{
		remove_filter('wp_nav_menu_items', 'webinane_nav_donation_menu');
	}
}

if (! function_exists('lifeline_donation_remove_location_opt')) {
	add_filter('webinane_settings_donation_button', 'lifeline_donation_remove_location_opt', 20);
	/**
	 * lifeline_donation_remove_location_opt
	 *
	 * @return void
	 */
	function lifeline_donation_remove_location_opt($list)
	{
		$remove_index = array_search('Menu Location', array_column($list, 'label'));
		if ($remove_index) {
			unset($list[$remove_index]);
		}

		sort($list);
		return $list;
	}
}

if (! function_exists('lifeline_donation_remove_archive_opt')) {
	add_filter('lifeline_donation/settings', 'lifeline_donation_remove_archive_opt', 20);
	/**
	 * lifeline_donation_remove_archive_opt
	 *
	 * @return void
	 */
	function lifeline_donation_remove_archive_opt($list)
	{
		$remove_index = array_search('archive_setting', array_column($list, 'id'));
		if ($remove_index) {
			unset($list[$remove_index]);
		}

		sort($list);
		return $list;
	}
}

if (! function_exists('lifeline_donation_remove_menu_opt')) {
	add_filter('webinane_settings_donation_button', 'lifeline_donation_remove_menu_opt', 20);
	/**
	 * lifeline_donation_remove_menu_opt
	 *
	 * @return void
	 */
	function lifeline_donation_remove_menu_opt($list)
	{
		$remove_index = array_search('menu_donation_button_theme_location', array_column($list, 'attribute'));
		if ($remove_index) {
			unset($list[$remove_index]);
		}

		sort($list);
		return $list;
	}
}

/**
 * [lifeline_the_pagination description]
 *
 * @param  array   $args [description].
 * @param  integer $echo [description].
 * @return [type]        [description]
 */
function lifeline_the_pagination($args = array(), $echo = 1)
{

	global $wp_query;

	$default = array('base' => str_replace(99999, '%#%', esc_url(get_pagenum_link(99999))), 'format' => '?paged=%#%', 'show_all' => 'False', 'current' => max(1, get_query_var('paged')), 'total' => $args, 'next_text' => '<i class="fas fa-angle-double-right"></i>', 'prev_text' => '<i class="fas fa-angle-double-left"></i>', 'type' => 'list');



	$args = wp_parse_args($args, $default);



	$pagination = '' . str_replace('<ul class=\'page-numbers\'>', '<ul class="pagenation text-center">', paginate_links($default)) . '';



	if (paginate_links(array_merge(array('type' => 'array'), $args))) {
		if ($echo) {
			echo wp_kses_post($pagination);
		}
		return $pagination;
	}
}

/**
 * [lifeline_template description]
 *
 * @param  string $template_names     [description].
 * @param  boolean $load [description].
 * @param  boolean $require_once      [description].
 * @return [type]           [description]
 */
function lifeline_template($template_names, $load = false, $require_once = true)
{
	$located = '';
	foreach ((array) $template_names as $template_name) {
		if (! $template_name) {
			continue;
		}
		if (file_exists(get_stylesheet_directory() . '/' . $template_name)) {
			$located = get_stylesheet_directory() . '/' . $template_name;
			break;
		} elseif (file_exists(get_template_directory() . '/' . $template_name)) {
			$located = get_template_directory() . '/' . $template_name;
			break;
		} elseif (file_exists(ABSPATH . WPINC . '/theme-compat/' . $template_name)) {
			$located = ABSPATH . WPINC . '/theme-compat/' . $template_name;
			break;
		}
	}

	if ($load && '' != $located) {
		load_template($located, $require_once);
	}

	return $located;
}

/**
 * [actavista_template_load description]
 *
 * @param  string $template [description]
 * @param  array  $args     [description]
 * @return [type]           [description]
 */
function lifeline_template_load($templ = '', $args = array())
{

	$template = lifeline_template($templ);

	if (file_exists($template)) {
		extract($args);
		unset($args);

		include $template;
	}
}

function lifline_admin_script()
{
	wp_enqueue_style('redux-admin-style', get_template_directory_uri() . '/assets/css/redux-admin.css');
}

add_action('admin_enqueue_scripts', 'lifline_admin_script');

function ocdi_change_time_of_single_ajax_call()
{
	return 10;
}
// add_filter( 'ocdi/time_for_one_ajax_call', 'ocdi_change_time_of_single_ajax_call' );

// Enable SVG support for uploads
function allow_svg_upload($mimes)
{
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
}
add_filter('upload_mimes', 'allow_svg_upload');

// Fix SVG display in media library
function fix_svg_display()
{
	echo '<style>
        .attachment-266x266, .thumbnail img {
            width: 100% !important;
            height: auto !important;
        }
    </style>';
}
add_action('admin_head', 'fix_svg_display');
