<?php
if ( post_password_required() ) {
	return;
}
$count = wp_count_comments( get_the_ID() );
?>
<div id="comments">
	<?php if ( lifeline_get( $count, 'total_comments' ) > 0 ) : ?>
		<div class="comments-threads mt-50">
			<?php if ( have_comments() ) : ?>
				<h3 class="mb-0 font-weight-semibold text-dark"><?php echo esc_html( lifeline_get( $count, 'total_comments' ) ); ?> <span class="text-theme"><?php echo ( lifeline_get( $count, 'total_comments' ) > 1 ) ? esc_html__( 'Comments Found', 'lifeline' ) : esc_html__( 'Comment Found', 'lifeline' ); ?></span></h3>
				<ul class="comments-list mb-0 list-unstyled w-100">
					<?php
					wp_list_comments(
						array(
							'type'     => 'comment',
							'callback' => 'lifeline_comments_list',
							'format'   => 'null',
						)
					);
					?>
				</ul>
				<?php
				// Are there comments to navigate through?
				if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
					?>
					<nav class="navigation comment-navigation" role="navigation">
						<h1 class="screen-reader-text section-heading"><?php esc_html_e( 'Comment navigation', 'lifeline' ); ?></h1>
						<div class="nav-previous"><?php previous_comments_link( '&larr; ' . esc_html__( 'Older Comments', 'lifeline' ) ); ?></div>
						<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'lifeline' ) . ' &rarr;' ); ?></div>
					</nav><!-- .comment-navigation -->
					<?php
				endif; // Check for comment navigation
				?>
				<?php if ( ! comments_open() && get_comments_number() ) : ?>
					<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'lifeline' ); ?></p>
				<?php endif; ?>
				<?php
			endif; // have_comments()
			?>
		</div>
		<?php
	endif;
	if ( comments_open() ) :
		lifeline_comment_form();
	endif;
	?>
</div>
