jQuery(document).ready(function ($) {
	'use strict'

	const stickyHeader = document.querySelectorAll('header.stick');
	const stickyHeader2 = document.querySelectorAll('.bg-theme.stick');

	if (stickyHeader || stickyHeader2) {
		var width = window.innerWidth;

		if (width > 850) {
			if ($(stickyHeader).length > 0) {
				$(stickyHeader).scrollupbar();
			}
			if ($(stickyHeader2).length > 0) {
				$(stickyHeader2).scrollupbar();
			}
		}

		var topbar = $('.topbar');
		var topbar_height = topbar.height();

		// responsive header topbar space
		$('.res-btn').on('click', function () {
			if (topbar_height >= 1 && $("body").hasClass("menu-active")) {
				$(".res-menu-wrapper2").css({
					'top': topbar_height + 25 + 'px'
				});
			} else {
				$(".res-menu-wrapper2").css({
					'top': '0'
				});
			}
		});

		var header_dark = $("body").find("header.dark-header");
		if (topbar.length >= 1 && header_dark.length >= 1 && $(window).width() > 980) {
			topbar_height = topbar_height + 20;
			var $banner_id = $("#lifeline_banner");
			var $space_sec;
			if ($banner_id.length >= 1) {
				$space_sec = $banner_id;
			} else {
				$space_sec = $('section:first');
			}
			$space_sec.css({
				'margin-top': "-" + topbar_height + "px"
			});
		}

	}

	/*add banner space*/
	var menu_height = $('header').height();
	if ($('header:not(.dark-header)').hasClass('stick') && $(window).width() > 980) {
		var $banner_id = $("#lifeline_banner");
		var $space_sec;
		if ($banner_id.length >= 1) {
			$space_sec = $banner_id;
		} else {
			$space_sec = $('section:first');
		}
		$space_sec.css({
			'margin-top': menu_height + 'px'
		});
	}

	/*team*/
	var l = $(".team-detail-info li").length;
	for (var i = 0; i <= l; i++) {
		var team_list = $(".team-detail-info li").eq(i);
		var team_width = $(team_list).find("p").width();
		$(team_list).find("p").css({
			"margin-right": -team_width - 21
		});
	}

	/*search*/
	const target = document.querySelector('[data-js="search-target"]');
	// When Search Overlay exists
	if (target) {

		const input = target.querySelector('[data-js="search-input"]')

		var showOverlay = function () {
			show(target);
			input.focus();
		};

		var closeOverlay = function () {
			hide(target);
		};

		document.addEventListener('click', function (e) {
			// Open an overlay
			if (e.target.matches('[data-js="search-trigger"]')) {

				e.preventDefault();
				showOverlay();
			}

			// Close an overlay
			if (e.target.matches('[data-js="search-close"]')) {
				e.preventDefault();
				closeOverlay();
			}

		}, false);

		document.addEventListener('keydown', function (e) {

			// Check if the search overlay is opened
			if (document.body.classList.contains('overflow-hidden')) {

				// Close an overlay on Escape key click
				if (e.key === 'Escape' || e.keyCode === 27) {
					closeOverlay();
				}

			}

		});

	}

	/*scrollbar*/
	const mCustomScrollbar = document.querySelectorAll('data-mCustomScrollbar');
	if (mCustomScrollbar) {
		if ($.isFunction($.fn.mCustomScrollbar)) {
			$('.cases-list, .sidemenu').mCustomScrollbar({
				scrollbarPosition: "outside",
				setLeft: 0
			});
		}
	}

	/*header donation button settings*/
	$("#header_button_lifeline").css({
		"background-color": lifeline_data.header_button.bg_color,
		"color": lifeline_data.header_button.color
	});

	$("#header_button_lifeline").mouseenter(function () {
		$(this).css({
			"background-color": lifeline_data.header_button.bg_color_hover,
			"color": lifeline_data.header_button.color_hover
		});
	}).mouseleave(function () {
		$(this).css({
			"background-color": lifeline_data.header_button.bg_color,
			"color": lifeline_data.header_button.color
		})
	});
});

jQuery(window).ready(function () {
	jQuery(".loader").fadeOut();
});

function show(target) {
	target.style.opacity = 1;
	target.style.visibility = "visible";
}

function hide(target) {
	target.style.opacity = 0;
	target.style.visibility = "hidden";
}
