<?php
$config = kanni_kirki_config();

KANNI_Kirki::add_section( 'dt_site_layout_section', array(
	'title' => esc_html__( 'Site Layout', 'kanni' ),
	'priority' => 20
) );

	# site-layout
	KANNI_Kirki::add_field( $config, array(
		'type'     => 'radio-image',
		'settings' => 'site-layout',
		'label'    => esc_html__( 'Site Layout', 'kanni' ),
		'section'  => 'dt_site_layout_section',
		'default'  => kanni_defaults('site-layout'),
		'choices' => array(
			'boxed' =>  KANNI_THEME_URI.'/kirki/assets/images/site-layout/boxed.png',
			'wide' => KANNI_THEME_URI.'/kirki/assets/images/site-layout/wide.png',
		)
	));

	# site-boxed-layout
	KANNI_Kirki::add_field( $config, array(
		'type'     => 'switch',
		'settings' => 'site-boxed-layout',
		'label'    => esc_html__( 'Customize Boxed Layout?', 'kanni' ),
		'section'  => 'dt_site_layout_section',
		'default'  => '1',
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'kanni' ),
			'off' => esc_attr__( 'No', 'kanni' )
		),
		'active_callback' => array(
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
		)			
	));

	# body-bg-type
	KANNI_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-type',
		'label'    => esc_html__( 'Background Type', 'kanni' ),
		'section'  => 'dt_site_layout_section',
		'multiple' => 1,
		'default'  => 'none',
		'choices'  => array(
			'pattern' => esc_attr__( 'Predefined Patterns', 'kanni' ),
			'upload' => esc_attr__( 'Set Pattern', 'kanni' ),
			'none' => esc_attr__( 'None', 'kanni' ),
		),
		'active_callback' => array(
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-pattern
	KANNI_Kirki::add_field( $config, array(
		'type'     => 'radio-image',
		'settings' => 'body-bg-pattern',
		'label'    => esc_html__( 'Predefined Patterns', 'kanni' ),
		'description'    => esc_html__( 'Add Background for body', 'kanni' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-image' )
		),
		'choices' => array(
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern1.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern1.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern2.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern2.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern3.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern3.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern4.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern4.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern5.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern5.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern6.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern6.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern7.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern7.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern8.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern8.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern9.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern9.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern10.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern10.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern11.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern11.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern12.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern12.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern13.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern13.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern14.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern14.jpg',
			KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern15.jpg'=> KANNI_THEME_URI.'/kirki/assets/images/site-layout/pattern15.jpg',
		),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => '==', 'value' => 'pattern' ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)						
	));

	# body-bg-image
	KANNI_Kirki::add_field( $config, array(
		'type' => 'image',
		'settings' => 'body-bg-image',
		'label'    => esc_html__( 'Background Image', 'kanni' ),
		'description'    => esc_html__( 'Add Background Image for body', 'kanni' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-image' )
		),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => '==', 'value' => 'upload' ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-position
	KANNI_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-position',
		'label'    => esc_html__( 'Background Position', 'kanni' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-position' )
		),
		'default' => 'center',
		'multiple' => 1,
		'choices' => kanni_image_positions(),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => 'contains', 'value' => array( 'pattern', 'upload') ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-repeat
	KANNI_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-repeat',
		'label'    => esc_html__( 'Background Repeat', 'kanni' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-repeat' )
		),
		'default' => 'repeat',
		'multiple' => 1,
		'choices' => kanni_image_repeats(),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => 'contains', 'value' => array( 'pattern', 'upload' ) ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));	