<?php
if ( ! class_exists( 'IVA_Theme_Options' ) ) {

	class IVA_Theme_Options {

		private static $instance;

		private static $db_options;

		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {

				self::$instance = new self;
			}

			return self::$instance;
		}

		public function __construct() {
			// Refresh options variables after customizer save.
			add_action( 'after_setup_theme', array( $this, 'refresh' ) );
		}

		public static function defaults() {
			$defaults = array(
				// General
					'show-loader' => '0',
					'show-pagecomments' => '1',
					'showall-pagination' => '0',
					'google-map-key' => '',
					'mailchimp-key' => '',
					'show-to-top' => '1',

				// Site Identity
					'display-site-title' => 0,
					'display-site-tagline' => 0,
					'site-title-color' => '',
					'site-title-h-color' => '',
					'site-tagline-color' => '',
		  			'site-title-typo' => array(
		  				'font-family' => 'Josefin Sans',
		  				'font-fallback' => "'Josefin Sans',sans-serif",
		  				'font-type' => 'google',
		  				'font-weight' => '400',
		  				'font-style' => 'normal',
		  				'text-transform' => '',
		  				'text-align' => '',
		  				'text-decoration' => '',
		  				'fs-desktop' => '',
		  				'fs-desktop-unit' => '',
		  				'fs-tablet' => '',
		  				'fs-tablet-unit' => '',
		  				'fs-tablet-landscape' => '',
		  				'fs-tablet-landscape-unit' => '',
		  				'fs-mobile' => '',
		  				'fs-mobile-unit' => '',
		  				'lh-desktop' => '1.1',
		  				'lh-desktop-unit' => 'em',
		  				'lh-tablet' => '',
		  				'lh-tablet-unit' => '',
		  				'lh-tablet-landscape' => '',
		  				'lh-tablet-landscape-unit' => '',
		  				'lh-mobile' => '',
		  				'lh-mobile-unit' => '',
		  				'ls-desktop' => '',
		  				'ls-desktop-unit' => '',
		  				'ls-tablet' => '',
		  				'ls-tablet-unit' => '',
		  				'ls-tablet-landscape' => '',
		  				'ls-tablet-landscape-unit' => '',
		  				'ls-mobile' => '',
		  				'ls-mobile-unit' => '',		  				
		  			),
		  			'site-tagline-typo' => array(
		  				'font-family' => 'Poppins',
		  				'font-fallback' => "'Poppins',sans-serif",
		  				'font-type' => 'google',
		  				'font-weight' => '400',
		  				'font-style' => 'normal',
		  				'text-transform' => '',
		  				'text-align' => '',
		  				'text-decoration' => '',
		  				'fs-desktop' => '',
		  				'fs-desktop-unit' => '',
		  				'fs-tablet' => '',
		  				'fs-tablet-unit' => '',
		  				'fs-tablet-landscape' => '',
		  				'fs-tablet-landscape-unit' => '',
		  				'fs-mobile' => '',
		  				'fs-mobile-unit' => '',
		  				'lh-desktop' => '1.7',
		  				'lh-desktop-unit' => 'em',
		  				'lh-tablet' => '',
		  				'lh-tablet-unit' => '',
		  				'lh-tablet-landscape' => '',
		  				'lh-tablet-landscape-unit' => '',
		  				'lh-mobile' => '',
		  				'lh-mobile-unit' => '',
		  				'ls-desktop' => '',
		  				'ls-desktop-unit' => '',
		  				'ls-tablet' => '',
		  				'ls-tablet-unit' => '',
		  				'ls-tablet-landscape' => '',
		  				'ls-tablet-landscape-unit' => '',
		  				'ls-mobile' => '',
		  				'ls-mobile-unit' => '',		  				
		  			),					

				// Breadcrumb
				'show-breadcrumb' => '1',
				'apply-dark-bg-breadcrumb' => '0',
				'breadcrumb-style' => 'aligncenter',
				'breadcrumb-position' => 'header-top-relative',
				'change-breadcrumb-delimiter' => '0',
				'breadcrumb-delimiter' => 'fas fa-arrow-right',
				'breadcrumb-title-color' => '#000000',
				'breadcrumb-text-color' => '#000000',
				'breadcrumb-link-color' => '#000000',
				'breadcrumb-link-h-color' => '#ed1b6f',
					'breadcrumb-bg' => array(
						'background-color' => 'rgba(238, 45, 122,0.1)',
					),
					'breadcrumb-overlay-bg-color' => '1',
					'breadcrumb-title-typo' => array(
						'font-family' => 'Josefin Sans',
						'font-fallback' => "'Josefin Sans', sans-serif",
						'font-type' => 'google',
						'font-weight' => '700',
						'font-style' => 'normal',
						'text-transform' => '',
						'text-align' => '',
						'text-decoration' => '',
						'fs-desktop' => '30',
						'fs-desktop-unit' => 'px',
						'fs-tablet' => '',
						'fs-tablet-unit' => '',
						'fs-tablet-landscape' => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile' => '',
						'fs-mobile-unit' => '',
						'lh-desktop' => '1.1',
						'lh-desktop-unit' => 'em',
						'lh-tablet' => '',
						'lh-tablet-unit' => '',
						'lh-tablet-landscape' => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile' => '',
						'lh-mobile-unit' => '',
						'ls-desktop' => '',
						'ls-desktop-unit' => '',
						'ls-tablet' => '',
						'ls-tablet-unit' => '',
						'ls-tablet-landscape' => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile' => '',
						'ls-mobile-unit' => '',		  				
					),
					'breadcrumb-typo' => array(
						'font-family' => 'Poppins',
						'font-fallback' => "'Poppins', sans-serif",
						'font-type' => 'google',
						'font-weight' => '400',
						'font-style' => 'normal',
						'text-transform' => '',
						'text-align' => '',
						'text-decoration' => '',
						'fs-desktop' => '16',
						'fs-desktop-unit' => 'px',
						'fs-tablet' => '',
						'fs-tablet-unit' => '',
						'fs-tablet-landscape' => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile' => '',
						'fs-mobile-unit' => '',
						'lh-desktop' => '1.7',
						'lh-desktop-unit' => 'em',
						'lh-tablet' => '',
						'lh-tablet-unit' => '',
						'lh-tablet-landscape' => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile' => '',
						'lh-mobile-unit' => '',
						'ls-desktop' => '',
						'ls-desktop-unit' => '',
						'ls-tablet' => '',
						'ls-tablet-unit' => '',
						'ls-tablet-landscape' => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile' => '',
						'ls-mobile-unit' => '',		  				
					),		  			

				// Site Layout
					'site-layout' => 'wide',
					'site-boxed-layout' => '1',

				// Typography
					'menu-typo' => array(
						'font-family'              => 'Poppins',
						'font-fallback'            => "'Poppins', sans-serif",
						'font-type'                => 'google',
						'font-weight'              => '500',
						'font-style'               => 'normal',
						'text-transform'           => '',
						'text-align'               => '',
						'text-decoration'          => '',
						'fs-desktop'               => '16',
						'fs-desktop-unit'          => 'px',
						'fs-tablet'                => '',
						'fs-tablet-unit'           => '',
						'fs-tablet-landscape'      => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile'                => '',
						'fs-mobile-unit'           => '',
						'lh-desktop'               => '1.7',
						'lh-desktop-unit'          => 'em',
						'lh-tablet'                => '',
						'lh-tablet-unit'           => '',
						'lh-tablet-landscape'      => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile'                => '',
						'lh-mobile-unit'           => '',						
						'ls-desktop'               => '',
						'ls-desktop-unit'          => '',
						'ls-tablet'                => '',
						'ls-tablet-unit'           => '',
						'ls-tablet-landscape'      => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile'                => '',
						'ls-mobile-unit'           => '',		  				
					),				

					'h1-typo' => array(
						'font-family'              => 'Josefin Sans',
						'font-fallback'            => "'Josefin Sans', sans-serif",
						'font-type'                => 'google',
						'font-weight'              => '400',
						'font-style'               => 'normal',
						'text-transform'           => '',
						'text-align'               => '',
						'text-decoration'          => '',
						'fs-desktop'               => '60',
						'fs-desktop-unit'          => 'px',
						'fs-tablet'                => '',
						'fs-tablet-unit'           => '',
						'fs-tablet-landscape'      => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile'                => '',
						'fs-mobile-unit'           => '',
						'lh-desktop'               => '1.1',
						'lh-desktop-unit'          => 'em',
						'lh-tablet'                => '',
						'lh-tablet-unit'           => '',
						'lh-tablet-landscape'      => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile'                => '',
						'lh-mobile-unit'           => '',
						'ls-desktop'               => '0',
						'ls-desktop-unit'          => '',
						'ls-tablet'                => '',
						'ls-tablet-unit'           => '',
						'ls-tablet-landscape'      => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile'                => '',
						'ls-mobile-unit'           => '',		  				
					),

					'h2-typo' => array(
						'font-family'              => 'Josefin Sans',
						'font-fallback'            => "'Josefin Sans', sans-serif",
						'font-type'                => 'google',
						'font-weight'              => '400',
						'font-style'               => 'normal',
						'text-transform'           => '',
						'text-align'               => '',
						'text-decoration'          => '',
						'fs-desktop'               => '50',
						'fs-desktop-unit'          => 'px',
						'fs-tablet'                => '',
						'fs-tablet-unit'           => '',
						'fs-tablet-landscape'      => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile'                => '',
						'fs-mobile-unit'           => '',
						'lh-desktop'               => '1.1',
						'lh-desktop-unit'          => 'em',
						'lh-tablet'                => '',
						'lh-tablet-unit'           => '',						
						'lh-tablet-landscape'      => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile'                => '',
						'lh-mobile-unit'           => '',
						'ls-desktop'               => '0',
						'ls-desktop-unit'          => '',
						'ls-tablet'                => '',
						'ls-tablet-unit'           => '',
						'ls-tablet-landscape'      => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile'                => '',
						'ls-mobile-unit'           => '',		  				
					),

					'h3-typo' => array(
						'font-family'              => 'Josefin Sans',
						'font-fallback'            => "'Josefin Sans', sans-serif",
						'font-type'                => 'google',
						'font-weight'              => '400',
						'font-style'               => 'normal',
						'text-transform'           => '',
						'text-align'               => '',
						'text-decoration'          => '',
						'fs-desktop'               => '36',
						'fs-desktop-unit'          => 'px',
						'fs-tablet'                => '',
						'fs-tablet-unit'           => '',
						'fs-tablet-landscape'      => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile'                => '',
						'fs-mobile-unit'           => '',
						'lh-desktop'               => '1.1',
						'lh-desktop-unit'          => 'em',
						'lh-tablet'                => '',
						'lh-tablet-unit'           => '',
						'lh-tablet-landscape'      => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile'                => '',
						'lh-mobile-unit'           => '',
						'ls-desktop'               => '0',
						'ls-desktop-unit'          => '',
						'ls-tablet'                => '',
						'ls-tablet-unit'           => '',
						'ls-tablet-landscape'      => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile'                => '',
						'ls-mobile-unit'           => '',		  				
					),

					'h4-typo' => array(
						'font-family'              => 'Josefin Sans',
						'font-fallback'            => "'Josefin Sans', sans-serif",
						'font-type'                => 'google',
						'font-weight'              => '400',
						'font-style'               => 'normal',
						'text-transform'           => '',
						'text-align'               => '',
						'text-decoration'          => '',
						'fs-desktop'               => '28',
						'fs-desktop-unit'          => 'px',
						'fs-tablet'                => '',
						'fs-tablet-unit'           => '',
						'fs-tablet-landscape'      => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile'                => '',
						'fs-mobile-unit'           => '',
						'lh-desktop'               => '1.1',
						'lh-desktop-unit'          => 'em',
						'lh-tablet'                => '',
						'lh-tablet-unit'           => '',
						'lh-tablet-landscape'      => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile'                => '',
						'lh-mobile-unit'           => '',
						'ls-desktop'               => '0',
						'ls-desktop-unit'          => '',
						'ls-tablet'                => '',
						'ls-tablet-unit'           => '',
						'ls-tablet-landscape'      => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile'                => '',
						'ls-mobile-unit'           => '',		  				
					),

					'h5-typo' => array(
						'font-family'              => 'Josefin Sans',
						'font-fallback'            => "'Josefin Sans', sans-serif",
						'font-type'                => 'google',
						'font-weight'              => '400',
						'font-style'               => 'normal',
						'text-transform'           => '',
						'text-align'               => '',
						'text-decoration'          => '',
						'fs-desktop'               => '22',
						'fs-desktop-unit'          => 'px',
						'fs-tablet'                => '',
						'fs-tablet-unit'           => '',
						'fs-tablet-landscape'      => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile'                => '',
						'fs-mobile-unit'           => '',
						'lh-desktop'               => '1.1',
						'lh-desktop-unit'          => 'em',
						'lh-tablet'                => '',
						'lh-tablet-unit'           => '',
						'lh-tablet-landscape'      => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile'                => '',
						'lh-mobile-unit'           => '',
						'ls-desktop'               => '0',
						'ls-desktop-unit'          => '',
						'ls-tablet'                => '',
						'ls-tablet-unit'           => '',
						'ls-tablet-landscape'      => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile'                => '',
						'ls-mobile-unit'           => '',
					),

					'h6-typo' => array(
						'font-family'              => 'Josefin Sans',
						'font-fallback'            => "'Josefin Sans', sans-serif",
						'font-type'                => 'google',
						'font-weight'              => '400',
						'font-style'               => 'normal',
						'text-transform'           => '',
						'text-align'               => '',
						'text-decoration'          => '',
						'fs-desktop'               => '18',
						'fs-desktop-unit'          => 'px',
						'fs-tablet'                => '',
						'fs-tablet-unit'           => '',
						'fs-tablet-landscape'      => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile'                => '',
						'fs-mobile-unit'           => '',
						'lh-desktop'               => '1.1',
						'lh-desktop-unit'          => 'em',
						'lh-tablet'                => '',
						'lh-tablet-unit'           => '',
						'lh-tablet-landscape'      => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile'                => '',
						'lh-mobile-unit'           => '',
						'ls-desktop'               => '0',
						'ls-desktop-unit'          => '',
						'ls-tablet'                => '',
						'ls-tablet-unit'           => '',
						'ls-tablet-landscape'      => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile'                => '',
						'ls-mobile-unit'           => '',		  				
					),

					'footer-title-typo' => array(
						'font-family' => 'Josefin Sans',
						'font-fallback' => "'Josefin Sans', sans-serif",
						'font-type' => 'google',
						'font-weight' => '600',
						'font-style' => 'normal',
						'text-transform' => '',
						'text-align' => '',
						'text-decoration' => '',
						'fs-desktop' => '20',
						'fs-desktop-unit' => 'px',
						'fs-tablet' => '',
						'fs-tablet-unit' => '',
						'fs-tablet-landscape' => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile' => '',
						'fs-mobile-unit' => '',
						'lh-desktop' => '1.1',
						'lh-desktop-unit' => 'em',
						'lh-tablet' => '',
						'lh-tablet-unit' => '',
						'lh-tablet-landscape' => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile' => '',
						'lh-mobile-unit' => '',
						'ls-desktop' => '',
						'ls-desktop-unit' => '',
						'ls-tablet' => '',
						'ls-tablet-unit' => '',
						'ls-tablet-landscape' => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile' => '',
						'ls-mobile-unit' => '',		  				
					),

					'footer-content-typo' => array(
						'font-family' => 'Poppins',
						'font-fallback' => "'Poppins',sans-serif",
						'font-type' => 'google',
						'font-weight' => '400',
						'font-style' => 'normal',
						'text-transform' => '',
						'text-align' => '',
						'text-decoration' => '',
						'fs-desktop' => '16',
						'fs-desktop-unit' => 'px',
						'fs-tablet' => '',
						'fs-tablet-unit' => '',
						'fs-tablet-landscape' => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile' => '',
						'fs-mobile-unit' => '',
						'lh-desktop' => '1.7',
						'lh-desktop-unit' => 'em',						
						'lh-tablet' => '',
						'lh-tablet-unit' => '',
						'lh-tablet-landscape' => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile' => '',
						'lh-mobile-unit' => '',
						'ls-desktop' => '',
						'ls-desktop-unit' => '',
						'ls-tablet' => '',
						'ls-tablet-unit' => '',
						'ls-tablet-landscape' => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile' => '',
						'ls-mobile-unit' => '',		  				
					),		  			

		  			'extra-1-typo' => array(
		  				'font-family' => 'Poppins',
		  				'font-fallback' => "'Poppins',sans-serif",
		  				'font-type' => 'google',
		  				'font-weight' => '400',
		  				'font-style' => 'normal',
		  				'text-transform' => '',
		  				'text-align' => '',
		  				'text-decoration' => '',
		  				'fs-desktop' => '',
		  				'fs-desktop-unit' => '',
		  				'fs-tablet' => '',
		  				'fs-tablet-unit' => '',
		  				'fs-tablet-landscape' => '',
		  				'fs-tablet-landscape-unit' => '',
		  				'fs-mobile' => '',
		  				'fs-mobile-unit' => '',
		  				'lh-desktop' => '',
						'lh-desktop-unit' => '',		  				
		  				'lh-tablet' => '',
						'lh-tablet-unit' => '',		  				
		  				'lh-tablet-landscape' => '',
						'lh-tablet-landscape-unit' => '',
		  				'lh-mobile' => '',
						'lh-mobile-unit' => '',
		  				'ls-desktop' => '',
		  				'ls-desktop-unit' => '',
		  				'ls-tablet' => '',
		  				'ls-tablet-unit' => '',
		  				'ls-tablet-landscape' => '',
		  				'ls-tablet-landscape-unit' => '',
		  				'ls-mobile' => '',
		  				'ls-mobile-unit' => '',		  				
		  			),

		  			'extra-2-typo' => array(
						'font-family' => 'Josefin Sans',
						'font-fallback' => "'Josefin Sans', sans-serif",
		  				'font-type' => 'google',
		  				'font-weight' => '400',
		  				'font-style' => 'normal',
		  				'text-transform' => '',
		  				'text-align' => '',
		  				'text-decoration' => '',
		  				'fs-desktop' => '',
		  				'fs-desktop-unit' => '',
		  				'fs-tablet' => '',
		  				'fs-tablet-unit' => '',
		  				'fs-tablet-landscape' => '',
		  				'fs-tablet-landscape-unit' => '',
		  				'fs-mobile' => '',
		  				'fs-mobile-unit' => '',
		  				'lh-desktop' => '',
						'lh-desktop-unit' => '',		  				
		  				'lh-tablet' => '',
						'lh-tablet-unit' => '',		  				
		  				'lh-tablet-landscape' => '',
						'lh-tablet-landscape-unit' => '',
		  				'lh-mobile' => '',
						'lh-mobile-unit' => '',
		  				'ls-desktop' => '',
		  				'ls-desktop-unit' => '',
		  				'ls-tablet' => '',
		  				'ls-tablet-unit' => '',
		  				'ls-tablet-landscape' => '',
		  				'ls-tablet-landscape-unit' => '',
		  				'ls-mobile' => '',
		  				'ls-mobile-unit' => '',		  				
		  			),

		  		// Color
					'menu-color' => '#000000',
					'h1-color' => '#232323',
					'h2-color' => '#232323',
					'h3-color' => '#232323',
					'h4-color' => '#232323',
					'h5-color' => '#232323',
					'h6-color' => '#232323',

					'footer-title-color' => '',
					'footer-content-color' => '',
					'footer-content-a-color' => '',
					'footer-content-a-hover-color' => '',

				// Widget Area Tile
					'widget-title-tag' => 'h3',
					'widget-title-style' => 'type6',
					'widget-title-color' => '#232323',
					'widget-title-bg-color' => '',
					'widget-title-border-style' => 'none',
					'widget-title-border' => array(),
					'widget-title-border-color' => '',
					'widget-title-border-radius' => array(),
					'widget-title-typo' => array(
						'font-family' => 'Josefin Sans',
						'font-fallback' => "'Josefin Sans', sans-serif",
		  				'font-type' => 'google',
		  				'font-weight' => '400',
		  				'font-style' => 'normal',
		  				'text-transform' => '',
		  				'text-align' => '',
		  				'text-decoration' => '',
		  				'fs-desktop' => '',
		  				'fs-desktop-unit' => '',
		  				'fs-tablet' => '',
		  				'fs-tablet-unit' => '',
		  				'fs-tablet-landscape' => '',
		  				'fs-tablet-landscape-unit' => '',
		  				'fs-mobile' => '',
		  				'fs-mobile-unit' => '',
		  				'lh-desktop' => '1.1',
						'lh-desktop-unit' => 'em',		  				
		  				'lh-tablet' => '',
						'lh-tablet-unit' => '',		  				
		  				'lh-tablet-landscape' => '',
						'lh-tablet-landscape-unit' => '',
		  				'lh-mobile' => '',
						'lh-mobile-unit' => '',
		  				'ls-desktop' => '',
		  				'ls-desktop-unit' => '',
		  				'ls-tablet' => '',
		  				'ls-tablet-unit' => '',
		  				'ls-tablet-landscape' => '',
		  				'ls-tablet-landscape-unit' => '',
		  				'ls-mobile' => '',
		  				'ls-mobile-unit' => '',		  				
		  			),

		  			'widget-content-color' => '',
		  			'widget-content-link-color' => '',
		  			'widget-content-link-hover-color' => '',
					'widget-content-typo' => array(
		  				'font-family' => 'Poppins',
		  				'font-fallback' => "'Poppins',sans-serif",
		  				'font-type' => 'google',
		  				'font-weight' => '400',
		  				'font-style' => 'normal',
		  				'text-transform' => '',
		  				'text-align' => '',
		  				'text-decoration' => '',
		  				'fs-desktop' => '',
		  				'fs-desktop-unit' => '',
		  				'fs-tablet' => '',
		  				'fs-tablet-unit' => '',
		  				'fs-tablet-landscape' => '',
		  				'fs-tablet-landscape-unit' => '',
		  				'fs-mobile' => '',
		  				'fs-mobile-unit' => '',
		  				'lh-desktop' => '1.7',
						'lh-desktop-unit' => 'em',		  				
		  				'lh-tablet' => '',
						'lh-tablet-unit' => '',		  				
		  				'lh-tablet-landscape' => '',
						'lh-tablet-landscape-unit' => '',
		  				'lh-mobile' => '',
						'lh-mobile-unit' => '',
		  				'ls-desktop' => '',
		  				'ls-desktop-unit' => '',
		  				'ls-tablet' => '',
		  				'ls-tablet-unit' => '',
		  				'ls-tablet-landscape' => '',
		  				'ls-tablet-landscape-unit' => '',
		  				'ls-mobile' => '',
		  				'ls-mobile-unit' => '',		  				
		  			),

				// All Page Settings
					// Archive Pages
						'site-global-sidebar-layout'					=> 'with-both-sidebar',
						'blog-archives-page-layout'						=> 'with-both-sidebar',
						'show-standard-left-sidebar-for-post-archives'  => '1',
						'show-standard-right-sidebar-for-post-archives' => '1',
						'blog-post-layout'								=> 'entry-grid',
						'blog-post-grid-list-style'						=> 'dt-sc-classic-ii',
						'blog-post-cover-style'							=> 'dt-sc-classic-ii',
						'blog-post-columns'								=> 'one-third-column',
						'blog-list-thumb'								=> 'entry-left-thumb',
						'blog-alignment'								=> 'aligncenter',
						'enable-equal-height'							=> '0',
						'enable-no-space'								=> '0',
						'enable-gallery-slider'							=> '0',
						'blog-elements-position'						=> array(
							'feature_image',
							'title',
							'meta_group',
							'content',
							'read_more',
						),
						'blog-meta-position'							=> array(
							'author',
							'date',
							'comments',
						),
						'enable-post-format'							=> '0',
						'enable-excerpt-text'							=> '1',
						'blog-excerpt-length'							=> '15',
						'enable-video-audio'							=> '0',
						'blog-readmore-text'							=> esc_html__('Read More', 'iva'),
						'blog-image-hover-style'						=> 'dt-sc-default',
						'blog-image-overlay-style'						=> 'dt-sc-default',
						'blog-pagination'								=> 'numbered',

					// Single Page
						'post-elements-position'						=> array(
							'content',
							'meta_group',
							'navigation',
							'related_article',
							'comment_box',
						),
						'post-meta-position'							=> array(
							'categories',
							'tags',
						),
						'post-related-title'							=> esc_html__('Related Posts', 'iva'),
						'post-related-columns'							=> 'one-third-column',
						'post-related-count'							=> '3',
						'enable-related-excerpt'						=> '0',
						'post-related-excerpt'							=> '25',
						'enable-related-carousel'						=> '0',
						'related-carousel-nav'							=> '',
						'enable-image-lightbox'							=> '0',
						'post-comments-list-style'						=> 'rounded',

					// 404 Page Settings
						'enable-404message'								=> '1',
						'notfound-style'								=> 'type1',
						'notfound-darkbg'								=> '0',
						'notfound-pageid'								=> '',
						'notfound_background'							=> '',
						'notfound-bg-style'								=> '',

				// Hooks
						'enable-top-hook'								=> '0',
						'top-hook'										=> '',
						'enable-content-before-hook'					=> '0',
						'content-before-hook'							=> '',
						'enable-content-after-hook'						=> '0',
						'content-after-hook'							=> '',
						'enable-bottom-hook'							=> '0',
						'bottom-hook'									=> '',
						'enable-analytics-code'							=> '0',
						'analytics-code'								=> '',
						
				// Sociable
						'sociable-delicious'							=> '',
						'sociable-deviantart'							=> '',
						'sociable-digg'									=> '',
						'sociable-dribbble'								=> '',
						'sociable-envelope'								=> '',
						'sociable-facebook'								=> '',
						'sociable-flickr'								=> '',
						'sociable-google-plus'							=> '#',
						'sociable-gtalk'								=> '',
						'sociable-instagram'							=> '',
						'sociable-lastfm'								=> '',
						'sociable-linkedin'								=> '#',
						'sociable-pinterest'							=> '',
						'sociable-reddit'								=> '',
						'sociable-rss'									=> '',
						'sociable-skype'								=> '',
						'sociable-stumbleupon'							=> '',
						'sociable-tumblr'								=> '#',
						'sociable-twitter'								=> '',
						'sociable-viadeo'								=> '',
						'sociable-vimeo'								=> '',
						'sociable-yahoo'								=> '',
						'sociable-youtube'								=> '',

				// Skin
					'primary-color'					=> '#ee2d7a',
					'secondary-color'				=> '#ed1b6f',
					'tertiary-color'				=> '#fdefe1',

					'body-bg-color'					=> '#ffffff',
					'body-content-color'	        => '#848484',
					'body-content-link-color'		=> '#151413',
					'body-content-link-hover-color' => '#ed1b6f',
					'body-typo' => array(
						'font-family' => 'Poppins',
						'font-fallback' => "'Poppins',sans-serif",
						'font-type' => 'google',
						'font-weight' => '400',
						'font-style' => 'normal',
						'text-transform' => '',
						'text-align' => '',
						'text-decoration' => '',
						'fs-desktop' => '16',
						'fs-desktop-unit' => 'px',
						'fs-tablet' => '',
						'fs-tablet-unit' => '',
						'fs-tablet-landscape' => '',
						'fs-tablet-landscape-unit' => '',
						'fs-mobile' => '',
						'fs-mobile-unit' => '',
						'lh-desktop' => '1.7',
						'lh-desktop-unit' => 'em',
						'lh-tablet' => '',
						'lh-tablet-unit' => '',
						'lh-tablet-landscape' => '',
						'lh-tablet-landscape-unit' => '',
						'lh-mobile' => '',
						'lh-mobile-unit' => '',
						'ls-desktop' => '',
						'ls-desktop-unit' => '',
						'ls-tablet' => '',
						'ls-tablet-unit' => '',
						'ls-tablet-landscape' => '',
						'ls-tablet-landscape-unit' => '',
						'ls-mobile' => '',
						'ls-mobile-unit' => '',		  				
					),
				
	

				// Additional JS
					'additional-js' => '',

					
			);

			return apply_filters( 'dttheme_default_settings', $defaults  );
		}

		public static function get_options() {
			self::refresh();
			return self::$db_options;
		}		

		/**
		 * Update theme static option array with sane defaults.
		 * @link  https://make.wordpress.org/themes/2014/07/09/using-sane-defaults-in-themes/
		 */
		public static function refresh() {
			self::$db_options = wp_parse_args(
				get_option( IVA_THEME_SETTINGS, array() ),
				self::defaults()
			);
		}
	}
}

IVA_Theme_Options::get_instance();

/**
 * Retrieves an option value based on an option name.
 *
 */
if ( ! function_exists( 'iva_get_option' ) ) {

	function iva_get_option( $option, $default = '' ) {

		$theme_options = IVA_Theme_Options::get_options();

		/**
		 * 
		 */
		$theme_options = apply_filters( 'iva_get_option_array', $theme_options, $option, $default );

		$value = ( isset( $theme_options[ $option ] ) && '' !== $theme_options[ $option ] ) ? $theme_options[ $option ] : $default;

		/**
		 * Dynamic filter iva_get_option_$option.
		 */
		return apply_filters( "iva_get_option_{$option}", $value, $option, $default );
	}
}