<?php
namespace MetForm_Pro\Core\Integrations\Payment\Ipn;

class Paypal_Ipn {
    
    private $use_sandbox = false;

    private $use_local_certs = true;

     const VERIFY_URI = 'https://paypal.com/cgi-bin/webscr';
     const SANDBOX_VERIFY_URI = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
 
     const VALID = 'VERIFIED';
     const INVALID = 'INVALID';
 
     public function useSandbox()
     {
         $this->use_sandbox = true;
     }
 
     public function getPaypalUri()
     {
         if ($this->use_sandbox) {
             return self::SANDBOX_VERIFY_URI;
         } else {
             return self::VERIFY_URI;
         }
     }
 
     public function usePHPCerts()
    {
        $this->use_local_certs = false;
    }

     public function verifyIPN()
     {
         if ( ! count($_POST)) {
             throw new Exception("Missing POST Data");
         }
 
         $raw_post_data = file_get_contents('php://input');
         $raw_post_array = explode('&', $raw_post_data);
         $myPost = array();
         foreach ($raw_post_array as $keyval) {
             $keyval = explode('=', $keyval);
             if (count($keyval) == 2) {
                 if ($keyval[0] === 'payment_date') {
                     if (substr_count($keyval[1], '+') === 1) {
                         $keyval[1] = str_replace('+', '%2B', $keyval[1]);
                     }
                 }
                 $myPost[$keyval[0]] = urldecode($keyval[1]);
             }
         }
 
         $req = 'cmd=_notify-validate';
         $get_magic_quotes_exists = false;
         if (function_exists('get_magic_quotes_gpc')) {
             $get_magic_quotes_exists = true;
         }
         foreach ($myPost as $key => $value) {
             if ($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
                 $value = urlencode(stripslashes($value));
             } else {
                 $value = urlencode($value);
             }
             $req .= "&$key=$value";
         }
 
         $ch = curl_init($this->getPaypalUri());
         curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
         curl_setopt($ch, CURLOPT_POST, 1);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
         curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
         curl_setopt($ch, CURLOPT_SSLVERSION, 6);
         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
         curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
 
         if ($this->use_local_certs) {
            curl_setopt($ch, CURLOPT_CAINFO, __DIR__ . "/cert/cacert.pem");
         }
         curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
         curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
         curl_setopt($ch, CURLOPT_HTTPHEADER, array(
             'User-Agent: PHP-IPN-Verification-Script',
             'Connection: Close',
         ));
         $res = curl_exec($ch);
         if ( ! ($res)) {
             $errno = curl_errno($ch);
             $errstr = curl_error($ch);
             curl_close($ch);
             throw new Exception("cURL error: [$errno] $errstr");
         }
 
         $info = curl_getinfo($ch);
         $http_code = $info['http_code'];
         if ($http_code != 200) {
             throw new Exception("PayPal responded with http code $http_code");
         }
 
         curl_close($ch);
        if ($res == self::VALID) {
             return true;
         } else {
             return false;
         }
     }

}
