<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get header
get_header();

// Current paged
$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

// Get donation type
$donation_type = egovt_get_meta_data( 'donation_type', $_GET, get_theme_mod( 'archive_donation_show_sidebar', '' ) );

// Get id
$id = get_the_ID();

// Base query
$args_base = [
	'post_type' 	=> 'give_forms',
	'post_status' 	=> 'publish',
	'paged' 		=> $paged
];

// Get form categories
$category = get_the_terms( $id, 'give_forms_category') ? get_the_terms( $id, 'give_forms_category') : '' ;
if ( '' != $category ) {
	// Get term id
	$term_id = get_queried_object()->term_id;

	// Update base query
	$args_base = [
		'post_type' 	=> 'give_forms',
		'post_status' 	=> 'publish',
		'paged' 		=> $paged,
		'tax_query' 	=> [
			[
				'taxonomy' => 'give_forms_category',
				'field'    => 'term_id',
				'terms'    => $term_id
			]
		]
	];

	// Type 5
	if ( 'type_5' === $donation_type ) { 
		$args_base = [
			'post_type' 		=> 'give_forms',
			'post_status' 		=> 'publish',
			'posts_per_page' 	=> -1,
			'paged' 			=> $paged,
			'tax_query' 		=> [
				[
					'taxonomy' => 'give_forms_category',
					'field'    => 'term_id',
					'terms'    => $term_id
				]
			]
		];					
	}
}

// Get give donation
$give_donation = new WP_Query( $args_base );

?>

<div class="container">
	<div class="archive_give_donation content_related content_archive <?php echo esc_attr( $donation_type ); ?>">
		<div class="summary">
			<?php if ( 'type_2' === $donation_type || 'type_3' === $donation_type || 'type_5' === $donation_type ): ?>
				<div class="title_archive second_font">
					<?php esc_html_e( 'See Our Campains', 'egovt' ); ?>
				</div>
				<div class="title_archive2 second_font">
					<?php echo  'Each donation is essential to </br> help others always' ; ?>
				</div>
			<?php endif; ?>
			<div class="wrap_summary">
				<?php if ( $give_donation->have_posts() ) : while ( $give_donation->have_posts() ) : $give_donation->the_post();
					// Get form id
					$id = get_the_ID();

					// Get thumbnail
					$thumbnail = wp_get_attachment_image_url( get_post_thumbnail_id( $id ) );
					if ( !$thumbnail ) $thumbnail = egovt_get_campaign_image_url( $id );

					// Show goal
					$show_goal = give_get_meta( $id, '_give_goal_option', true );

					// Progress stats
					$progress_stats = apply_filters( 'ova_progress_stats', $id );

					// Get progress
					$progress = egovt_get_meta_data( 'progress', $progress_stats );

					// Get actual
					$actual = egovt_get_meta_data( 'actual', $progress_stats );

					// Get goal
					$goal = egovt_get_meta_data( 'goal', $progress_stats );

					// Get title
					$title = get_the_title( $id );

					// Get link
					$link = get_the_permalink( $id );

					// Excerpt
					$excerpt = get_the_excerpt( $id );
					if ( '[]' === $excerpt ) $excerpt = '';
			
				?>
					<div class="give_detail">
						<div class="image_future">
							<div class="thumbnail">
								<a href="<?php echo esc_url( $link ); ?>">
									<img src="<?php echo $thumbnail; ?>" alt="<?php echo esc_attr( $title ); ?>">
								</a>
							</div>
						</div>
						<div class="detail_body">
							<h3 class="second_font title">
								<a href="<?php echo esc_url( $link ); ?>">
									<?php echo wp_kses_post( $title ); ?>
								</a>
							</h3>
							<?php if ( $excerpt ): ?>
								<p class="desc">
									<?php echo wp_kses_post( $excerpt ); ?>
								</p>
							<?php endif;

							// Goal
							if ( 'disabled' != $show_goal ): ?>
								<div class="progress">
									<?php if ( $progress < '50' ): ?>
										<span class="wrap_percentage_1" style="width: <?php echo esc_attr( $progress.'%' ); ?>; ">
											<span class="percentage">
												<?php echo esc_attr( $progress.'%' ); ?>
											</span>
										</span>
									<?php elseif ( $progress >= '50'):  ?>
										<span class="wrap_percentage_2" style="width: <?php echo esc_attr( $progress.'%' ); ?>; ">
											<span class="percentage">
												<?php echo esc_attr( $progress.'%' ); ?>
											</span>
										</span>
									<?php endif; ?>
								</div>
							<?php endif; ?>
							<div class="raised">
								<div class="income">
									<span class="second_font">
										<?php esc_html_e( 'Raised', 'egovt' ); ?>
									</span>
									<span><?php echo esc_html( $actual ); ?></span>
								</div>
								<span class="ingo"><?php esc_html_e( '/', 'egovt' ); ?></span>
								<?php if ( 'disabled' != $show_goal ): ?>
									<div class="goal">
										<span class="second_font">
											<?php esc_html_e( 'Goal', 'egovt' ); ?>
										</span>
										<span><?php echo esc_html( $goal ); ?></span>
									</div>
								<?php endif; ?>
							</div>
							<div class="donate_remaining">
								<a href="<?php echo esc_url( $link ); ?>" class="donate second_font">
									<?php esc_html_e( 'Donate Now', 'egovt' ); ?>
								</a>
							</div>
						</div>
					</div>
				<?php endwhile; 
				else: ?>
					<div class="search_not_found">
						<?php esc_html_e( 'No donation form found!', 'egovt' ); ?>
					</div>
				<?php endif; wp_reset_postdata(); wp_reset_query(); ?>
			</div>
			<?php if ( 'type_5' != $donation_type ) {
				egovt_pagination_theme( $give_donation );
			} ?>
		</div>
		<div class="sidebar sidebar_give">
			<?php do_action( 'give_before_single_form_summary' ); ?>
		</div>
	</div>
</div>
<?php get_footer(); ?>