<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'verify_envato_purchase' );
function verify_envato_purchase() {
	
if(isset($_POST['purchase_code']) && isset($_POST['purchase_code_nonce']) ){
	   
	$notices = array();
	
	if( wp_verify_nonce( $_POST['purchase_code_nonce'], 'purchase_code_activation' ) ) {
			
		$purchase_code = htmlspecialchars($_POST['purchase_code']);	
		$duplexotheme_purchase_code_old     = get_option( 'duplexotheme_purchase_code' );
		$duplexowebsite_url_key_old     = get_option( 'duplexowebsite_url_key' );		
		$duplexo_site_url = get_site_url();		
		
		$duplexowebsite_url_key = md5($duplexo_site_url);
		$duplexo_purchasecode_notices = get_option( 'duplexo_purchasecode_notices' );
	
			// If empty purchase code provided
			if( empty($purchase_code) ){
				delete_option( 'duplexotheme_purchase_code' );
				$notices = array(
					'notice_type' => 'warning',
					'notice'      => esc_html__( 'Please enter your purchase code', 'duplexo' ),
				);
			}
			else {
				
				// Prevalidate purchase code structure
				if ( true !== duplexo_prevalidate_purchase_codenum( $purchase_code ) ) {
						delete_option( 'duplexotheme_purchase_code' );
						$notices = array(
						'notice_type' => 'warning',
						'notice'      => esc_html__( 'Please enter a valid purchase code', 'duplexo' ),
					);
				}
				else {
					
					if (($duplexotheme_purchase_code_old == $purchase_code) && ($duplexowebsite_url_key_old == $duplexowebsite_url_key)){
						$notices = array(
							'notice_type' => 'warning',
							'notice'      => esc_html__( 'Purchase code is already activated on this website', 'duplexo' ),
						);
					} else {
						delete_option( 'duplexotheme_purchase_code' );
						$args = array(
							'purchase_key'  => $purchase_code,
							'site_url' 		=> get_site_url(),
							'action'		=> '1'
						);
						
						$url = add_query_arg( $args, CMT_ENVATO_API . '?');

						$response = wp_remote_post( $url, array( 'timeout' => 2000 ) );
				
						if( is_wp_error($response) ){
							$notices = array(
								'notice_type' => 'error',
								'notice'      => esc_html__('There was an error processing your request, please try again', 'duplexo'),
							);
						} else {
								$response_code = wp_remote_retrieve_response_code( $response );
								$response_body = json_decode( wp_remote_retrieve_body( $response ), true );
		
							if ( $response_code == '200' ) {
									if($response_body['status'] == 1){
										
										$notices = array(
											'notice_type' => 'success',
											'notice'      => $response_body['message'],
										);
										update_option( 'duplexopurchase-verify', 'yes' );
										update_option( 'duplexotheme_purchase_code', $purchase_code );
										update_option('duplexowebsite_url_key', $duplexowebsite_url_key);
									}else{
										$notices = array(
											'notice_type' => 'error',
											'notice'      => $response_body['message'],
										);
									}
								} else {
									$notices = array(
										'notice_type' => 'warning',
										'notice'      => $response_body['message'],
									);
								}
							}
						}
					}
			}

	}
	else {
			$notices = array(
				'notice_type' => 'error',
				'notice'      => esc_html__( 'Unable to verify security check. Please try to reload the page', 'duplexo' ),
			);
		}

	update_option( 'duplexo_purchasecode_notices', $notices );
}


if(isset($_POST['purchase_code_deactive']) && !empty($_POST['purchase_code_deactive']) ){
	$notices = array();
	$purchase_code = htmlspecialchars($_POST['purchase_code_deactive']);	
	$duplexotheme_purchase_code_old  = get_option( 'duplexotheme_purchase_code' );
	$duplexo_site_url = get_site_url();	
	
	
	if (($duplexotheme_purchase_code_old != $purchase_code)){
		$notices = array(
			'notice_type' => 'warning',
			'notice'      => esc_html__( 'There was an error processing your request, please try again', 'duplexo' ),
		);
	}
	else {
		$args = array(
			'purchase_key'  => $purchase_code,
			'site_url' 		=> get_site_url(),
			'action'		=> '0'
		);

		$url = add_query_arg( $args, CMT_ENVATO_API . '?');

		$response = wp_remote_get( $url, array( 'timeout' => 2000 ) );
		
		
		if( is_wp_error($response) ){
			$notices = array(
				'notice_type' => 'error',
				'notice'      => esc_html__('There was an error processing your request, please try again', 'duplexo'),
			);
		} else {
				$response_code = wp_remote_retrieve_response_code( $response );
				$response_body = json_decode( wp_remote_retrieve_body( $response ), true );
				
				if ( $response_code == '200' ) {
					if($response_body['status'] == 1){
						
						$notices = array(
							'notice_type' => 'success',
							'notice'      => $response_body['message'],
						);
						update_option( 'duplexopurchase-verify', 'no' );
						delete_option( 'duplexotheme_purchase_code' );
						delete_option( 'duplexowebsite_url_key' );
					}else{
						$notices = array(
							'notice_type' => 'error',
							'notice'      => $response_body['message'],
						);
					}
				} else {
					$notices = array(
						'notice_type' => 'warning',
						'notice'      => $response_body['message'],
					);
				}							
			}
	}
	update_option( 'duplexo_purchasecode_notices', $notices );				
}



}



function duplexo_prevalidate_purchase_codenum( $purchase_code ) {
	$purchase_code = preg_replace( '#([a-z0-9]{8})-?([a-z0-9]{4})-?([a-z0-9]{4})-?([a-z0-9]{4})-?([a-z0-9]{12})#', '$1-$2-$3-$4-$5', strtolower( $purchase_code ) );
	if ( 36 == strlen( $purchase_code ) ) {
		return true;
	}
	return false;
}
?>