<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Fact & Digit Widget.
*/
 
class Duplexo_Imagebox_Widget extends Widget_Base{

	public function get_name() {
		return 'cmt_imagebox_element';
	}

	public function get_title() {
		return esc_attr__( 'Image Box1', 'duplexo' );
	}

	public function get_icon() {
		return 'eicon-image';
	}

	public function get_categories() {
		return [ 'duplexo_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}  
	
	protected function register_controls() {

		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'Content', 'duplexo' ),
			]
        );
		
		
		$this->add_control(
			'view',
			[
				'label'			=> esc_attr__( 'Design', 'duplexo' ),
				'description'	=> esc_attr__( 'Select box design.', 'duplexo' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'one',
				'options' => [
					'one'	=> esc_attr( 'Style 1' ),
					'two'	=> esc_attr( 'Style 2' ),
				],
			]
		);
		$this->add_control(
			'image',
			[
				'label'			=> esc_attr__( 'Choose Image', 'duplexo' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'image',
				'default' => 'large',
				'separator' => 'none',
			]
		);
			$this->add_control(
			'image_link',
			[
				'label' => esc_attr__( 'Image Link', 'duplexo' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		

		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'duplexo' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'duplexo' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'duplexo' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'duplexo' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
            'cmt_reveal_effects_enable',
            [
                'label'              => esc_html__('Use Reveal Effects?', 'duplexo'),
                'type'               => Controls_Manager::SWITCHER,
                'render_type'        => 'none',
                'frontend_available' => true,
                'prefix_class'       => 'cmt-reveal-effects-',
            ]
        );
        $this->add_control(
            'cmt_reveal_effects_direction',
            [
                'label'              => __('Direction', 'duplexo'),
                'type'               => Controls_Manager::SELECT,
                'default'            => 'lr',
                'options'            => [
                    'lr' => __('Left to Right', 'duplexo'),
                    'rl' => __('Right to Left', 'duplexo'),
                   ],
                'frontend_available' => true,
				'prefix_class'       => 'cmt-reveal-direction-',
                'condition'          => [
                    'cmt_reveal_effects_enable' => 'yes'
                ]
            ]
        );
		
		
		$this->add_control(
			'heading',
			[
				'label' => esc_attr__( 'Heading', 'duplexo' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( 'Welcome to our site', 'duplexo' ),
				'placeholder' => esc_attr__( 'Enter text for heading line.', 'duplexo' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'heading_link',
			[
				'label' => esc_attr__( 'Heading Link', 'duplexo' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'desc',
			[
				'label' => esc_attr__( 'Text', 'duplexo' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_attr__( 'Enter description text', 'duplexo' ),
				'label_block' => true,
				'condition' => [
                    'view' => 'one',
                ]
			]
		);

		$this->add_control(
			'btn_title',
			[
				'label' => esc_attr__( 'Button Title', 'duplexo' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'separator'		=> 'before',
				'placeholder' => esc_attr__( 'Enter button title text', 'duplexo' ),
				'label_block' => true,
				'condition' => [
                    'view' => 'one',
                ]
			]
		);
		
		$this->add_control(
			'btn_link',
			[
				'label' => esc_attr__( 'Button Link', 'duplexo' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
				'condition' => [
                    'view' => 'one',
                ]
			]
		);
		$this->add_control(
			'heading_tag',
			[
				'label' => esc_attr__( 'Heading Tag', 'duplexo' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1'	=> esc_attr( 'H1' ),
					'h2'	=> esc_attr( 'H2' ),
					'h3'	=> esc_attr( 'H3' ),
					'h4'	=> esc_attr( 'H4' ),
					'h5'	=> esc_attr( 'H5' ),
					'h6'	=> esc_attr( 'H6' ),
					'div'	=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h2' ),
			]
		);
		
		$this->end_controls_section();

	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		
		global $cmt_global_imagebox_element_values;
		$cmt_global_imagebox_element_values = array();
		
		$return = $heading_html = $content_html = $button_html= '';


		$class         = array();

		if( !empty($view) ){
			$class[] = 'cmt-imgbox-'.$view;
		}

		
		// Media image
			$image_html		= '' ;
			if( defined('ELEMENTOR_VERSION') ){
				$image_html = Group_Control_Image_Size::get_attachment_image_src( $settings['image']['id'], 'image', $settings );
				$image_link = $settings['image_link']['url'];

				if( !empty($image_html) && !empty($settings['image_link']['url'] )){
					$image_html = '<a href="'.$image_link.'"> <img src="'.esc_url($image_html).'" class="cmt-single-image-img" alt="Image"/></a>';
				}
				else {
					$image_html = '<img src="'.esc_url($image_html).'" class="cmt-single-image-img" alt="Image"/>';
				}

			}

			if( !empty($settings['heading']) ) {
				$heading_tag	= ( !empty($settings['heading_tag']) ) ? $settings['heading_tag'] : 'h2' ;
				$heading_html	= '<'. cymolthemes_wp_kses($heading_tag) . ' class="cmt-custom-heading">
					'.cmt_link_render($settings['heading_link'], 'start' ).'
						'.cymolthemes_wp_kses($settings['heading']).'
					'.cmt_link_render($settings['heading_link'], 'end' ).'
					</'. cymolthemes_wp_kses($heading_tag) . '>
				';
			}
		
			if( !empty($settings['btn_title']) && !empty($settings['btn_link']['url']) ){
				$button_html = '<div class="cmt-iocnbox-btn">' . tm_link_render($settings['btn_link'], 'start' ) . cymolthemes_wp_kses($settings['btn_title']) . tm_link_render($settings['btn_link'], 'end' ) . '</div>';
			}
			
			if( !empty($settings['desc']) ){
				$content_html = '<div class="cmt-cta3-content-wrapper">'.cymolthemes_wp_kses($settings['desc']).'</div>';
			}
			
			
		if( file_exists( locate_template( '/template-parts/imagebox/imagebox-'.esc_attr($view).'.php', false, false ) ) ){

			ob_start();
			include( locate_template( '/template-parts/imagebox/imagebox-'.esc_attr($view).'.php', false, false ) ); 
			$return .= ob_get_contents();
			ob_end_clean();

		}
		
		echo cymolthemes_wp_kses($return);

	}


}
// Register widget
Plugin::instance()->widgets_manager->register( new Duplexo_Imagebox_Widget() );