<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Steps Box
*/
 
class Duplexo_Coverimgbox_Widget extends Widget_Base{

	public function get_name() {
		return 'cmt_coverimgbox_element';
	}

	public function get_title() {
		return esc_attr__( 'Cover Box', 'duplexo' );
	}

	public function get_icon() {
		return ' eicon-menu-toggle';
	}

	public function get_categories() {
		return [ 'duplexo_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}

	protected function register_controls() {
		
		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'General ', 'duplexo' ),
			]
		);
		
		$this->add_control(
			'icon_type',
			[
				'label' => esc_attr__( 'Icon Type', 'duplexo' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'icon'	=> esc_attr__( 'Icon', 'duplexo' ),
					'image'	=> esc_attr__( 'Image', 'duplexo' ),
					'text'	=> esc_attr__( 'Text', 'duplexo' ),
				],
				'default' => esc_attr( 'icon' ),
			]
		);
		
        $this->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'duplexo' ),
				'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'icon_type' => 'icon',
                ]
            ]

		);

        $this->add_control(
			'icon_image',
			[
				'label' => __( 'Select Image for Icon', 'duplexo' ),
				'description' => __( 'image will appear at icon position', 'duplexo' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image',
                ]
			]
		);
		
        $this->add_control(
			'icon_text',
			[
				'label' => esc_attr__( 'Text for Icon', 'duplexo' ),
				'description' => esc_attr__( 'Text will appear at icon position', 'duplexo' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( '01', 'duplexo' ),
				'placeholder' => esc_attr__( 'Enter text here', 'duplexo' ),
                'label_block' => true,
                'condition' => [
                    'icon_type' => 'text',
                ]
			]
		);
		$this->add_control(
			'icon_link',
			[
				'label' => esc_attr__( 'Icon Link', 'duplexo' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			
			]
		);
		
		$this->add_control(
			'heading',
			[
				'label' => esc_attr__( 'Heading', 'duplexo' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_attr__( 'Our Services', 'duplexo' ),
				'placeholder' => esc_attr__( 'Enter text for heading text.', 'duplexo' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'heading_link',
			[
				'label' => esc_attr__( 'Heading Link', 'duplexo' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		
		
		$this->end_controls_section();

		$this->start_controls_section(
			'data_section2',
			[
				'label' => esc_attr__( 'Boxes Content', 'duplexo' ),
			]
        );

		$repeater = new Repeater();

		 $repeater->add_control(
			'icon_image',
			[
				'label' => __( 'Select Image for Icon', 'duplexo' ),
				'description' => __( 'image will appear at icon position', 'duplexo' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
			]
		);

	
		$repeater->add_control(
			'label',
			[
				'label' => esc_attr__( 'Box Title', 'duplexo' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_attr__( 'Box Title', 'duplexo' ),
				'placeholder' => esc_attr__( 'Box Title', 'duplexo' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'label_link',
			[
				'label' => esc_attr__( 'Label Link', 'duplexo' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'smalltext',
			[
				'label' => esc_attr__( 'Box Content', 'duplexo' ),
				'default' => esc_attr__( 'Box Content', 'duplexo' ),
				'placeholder' => esc_attr__( 'Box Content', 'duplexo' ),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => true,
			]
		);

		$repeater->add_control(
			'link_text',
			[
				'label' => esc_attr__( 'Link Text', 'duplexo' ),
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_attr__( 'Like READ MORE text. This text will appear as link (fill link URL in below option).', 'duplexo' ),
				'placeholder' => esc_attr__( 'READ MORE', 'duplexo' ),
				'label_block' => true,
				'separator' => 'before',
			]
		);
		
		$repeater->add_control(
			'link_url',
			[
				'label' => esc_attr__( 'Link URL', 'duplexo' ),
				'description' => esc_attr__( 'Add link URL here.', 'duplexo' ),
				'type' => Controls_Manager::URL,
				'show_label' => true,
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
			]
		);
        $this->add_control(
			'boxes',
			[
				'label'		=> esc_attr__( 'Boxes', 'duplexo' ),
				'type'		=> Controls_Manager::REPEATER,
				'fields'	=> $repeater->get_controls(),
				'default'	=> [
					[
						'image'		=> get_template_directory_uri() . '/images/placeholder.png',
						'label'		=> esc_attr__( 'This is first box', 'duplexo' ),
						'smalltext'	=> esc_attr__( 'This is small description', 'duplexo' ),
					],
					[
						'image'		=> get_template_directory_uri() . '/images/placeholder.png',
						'label'		=> esc_attr__( 'This is second box', 'duplexo' ),
						'smalltext'	=> esc_attr__( 'This is small description', 'duplexo' ),
					],
				],
				'title_field' => '{{{ label }}}',
			]
		);

		$this->end_controls_section();



	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		$return = '';
		$link_html = '';
		$image_html		= '' ;
		$column_class = '';
		$icon_html ='';
		$headingclass= '';
		if( empty($settings['heading']) ){
			$headingclass = 'cmt-boxwithout-heading';
		}
		?>


		<?php
			$col_start_div	= '';
			$col_end_div	= '';
					if( !empty($boxes) ){
						switch( count($boxes) ){
					case 1:
						$column_class = 'one';
					break;
					
					case 2:
						$column_class = 'two';
					break;
					
					case 3:
						$column_class	 = 'three';
					break;
					
					case 4:
					default:
						$column_class = 'four';
					break;
				}
			} ?>
			
<div class="cmt_coverimgbox_wrapper cmt-column-<?php echo esc_attr($column_class); ?>">


		<?php
		$count = 1;
		$accclass = '';
		foreach( $settings['boxes'] as $box ){
			 

			$smalltext_html	= ( !empty($box['smalltext']) ) ? '<div class="cymolthemes-static-box-desc">'.esc_html($box['smalltext']).'</div>' : '' ;
			$label_html		= ( !empty($box['label']) ) ? '<div class="cmt-box-title"><h4>'.esc_html($box['label']).'</h4></div>' : '' ;

			if( !empty($box['label']) ){
				$label_html	= ''.cymolthemes_wp_kses($box['label']).'';
				$label_html = '<h4 class="cmt-box-title cmt-title-link">'.cmt_link_render($box['label_link'], 'start' ).''.$label_html.''.cmt_link_render($box['label_link'], 'end' ).'</h4>';
			}

							$icon_image = '<img src="'.esc_url($box['icon_image']['url']).'" alt="'.esc_attr($box['label']).'" />';
							$icon = '<div class="cmt-stepbox-imagebox"><div class="cmt-ptable-icon-type-image">' . $icon_image . '</div></div>';
							
						
					

			$link_html = '';
			if( !empty($box['link_text']) && isset($box['link_url']['url']) && !empty($box['link_url']['url']) ){
				$text = $box['link_text'];
				$link_html = '<a class="cmt-staticbox-more-link cmt-more-button" href="' . esc_url( $box['link_url']['url'] ) . '"  target="' . ( (!empty($box['link_url']['is_external']) && $box['link_url']['is_external']==true) ? '_blank' : '_self' ) . '">' . esc_attr( $text ) . '</a>' ;
			}
					ob_start();
					
					include( get_template_directory() . '/template-parts/coverimgbox/coverimgbox-default.php' );
					include( get_template_directory() . '/template-parts/coverimgbox/coverimgbox-default2.php' );
					$return .= ob_get_contents();
					ob_end_clean();
		$count++;

		}		
		
		
		if( !empty($settings['icon_type']) ){

				if( $settings['icon_type']=='text' ){
					$icon_html = '<div class="cmt-icon-type-text">' . $settings['icon_text'] . '</div>';
					$icon_type_class = 'text';

				} else if( $settings['icon_type']=='image' ){
					$icon_alt	= (!empty($settings['title'])) ? trim($settings['title']) : esc_attr__('Icon', 'duplexo') ;
					$icon_image = '<img src="'.esc_url($settings['icon_image']['url']).'" alt="'.esc_attr($icon_alt).'" />';
					$icon_html	= '<div class="cmt-icon-type-image">' . $icon_image . '</div>';
					$icon_type_class = 'image';
				} else if( $settings['icon_type']=='none' ){
					$icon_html = '';
					$icon_type_class = 'none';
				} else {

					$icon_html       = '<div class="cmt-box-icon"><i class="' . $settings['icon']['value'] . '"></i></div>';
					$icon_type_class = 'icon';

					wp_enqueue_style( 'elementor-icons-'.$settings['icon']['library']);
				}
		}
		
		if( !empty($settings['heading']) ) {
	
			$heading_html	= ''.cymolthemes_wp_kses($settings['heading']).'';
		}
			
		$return .=''.( !empty($settings['heading']) ) ? '<div class="cmt_coverbox_contents cmt-last"><div class="cmt-bottom-contentbox"><div class="cmt-contentbox-icon">'.$icon_html.'</div><div class="cmt-contentbox-heading">'.cmt_link_render($settings['heading_link'], 'start' ).''.$heading_html.''.cmt_link_render($settings['heading_link'], 'end' ).'</div></div></div>' : '';
		
		echo cymolthemes_wp_kses($return);
		
		?>

		</div>

	    <?php
	}

	

}
// Register widget
Plugin::instance()->widgets_manager->register( new Duplexo_Coverimgbox_Widget() );