<?php

if ( ! function_exists( 'coppola_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function coppola_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'coppola_filter_mobile_header_template', coppola_get_template_part( 'mobile-header', 'templates/mobile-header' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	add_action( 'coppola_action_page_header_template', 'coppola_load_page_mobile_header' );
}

if ( ! function_exists( 'coppola_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function coppola_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'coppola_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'coppola' ) ) );

		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}

	add_action( 'coppola_action_after_include_modules', 'coppola_register_mobile_navigation_menus' );
}
