<?php

if ( ! function_exists( 'coppola_register_justified_gallery_scripts' ) ) {
	/**
	 * Function that register module 3rd party scripts
	 */
	function coppola_register_justified_gallery_scripts() {
		wp_register_script( 'jquery-justified-gallery', COPPOLA_INC_ROOT . '/justified-gallery/assets/js/plugins/jquery.justifiedGallery.min.js', array( 'jquery' ), true );
	}

	add_action( 'coppola_action_before_main_js', 'coppola_register_justified_gallery_scripts' );
}

if ( ! function_exists( 'coppola_include_justified_gallery_scripts' ) ) {
	/**
	 * Function that enqueue modules 3rd party scripts
	 *
	 * @param array $atts
	 */
	function coppola_include_justified_gallery_scripts( $atts ) {

		if ( isset( $atts['behavior'] ) && 'justified-gallery' === $atts['behavior'] ) {
			wp_enqueue_script( 'jquery-justified-gallery' );
		}
	}

	add_action( 'coppola_core_action_list_shortcodes_load_assets', 'coppola_include_justified_gallery_scripts' );
}

if ( ! function_exists( 'coppola_register_justified_gallery_scripts_for_list_shortcodes' ) ) {
	/**
	 * Function that set module 3rd party scripts for list shortcodes
	 *
	 * @param array $scripts
	 *
	 * @return array
	 */
	function coppola_register_justified_gallery_scripts_for_list_shortcodes( $scripts ) {

		$scripts['jquery-justified-gallery'] = array(
			'registered' => true,
		);

		return $scripts;
	}

	add_filter( 'coppola_core_filter_register_list_shortcode_scripts', 'coppola_register_justified_gallery_scripts_for_list_shortcodes' );
}
