<?php
$link_url_meta  = get_post_meta( get_the_ID(), 'qodef_post_format_link', true );
$link_url       = ! empty( $link_url_meta ) ? $link_url_meta : get_the_permalink();
$link_text_meta = get_post_meta( get_the_ID(), 'qodef_post_format_link_text', true );
$link_img = get_the_post_thumbnail_url( get_the_ID() );

if ( ! empty( $link_url ) ) {
	$link_text = ! empty( $link_text_meta ) ? $link_text_meta : get_the_title();
	$title_tag = isset( $title_tag ) && ! empty( $title_tag ) ? $title_tag : 'h5';
	?>
	<div class="qodef-e-link">
		<div class="qodef-e-link-img" <?php if (isset( $link_img ) ) { ?>style="background: center / cover no-repeat url(<?php echo esc_url( $link_img ); ?>)"<?php } ?>></div>
		<div class="qodef-e-link-overlay"></div>
		<?php coppola_render_svg_icon( 'button-arrow', 'qodef-e-link-icon' ); ?>
		<<?php echo coppola_escape_title_tag( $title_tag ); ?> class="qodef-e-link-text"><?php echo esc_html( $link_text ); ?></<?php echo coppola_escape_title_tag( $title_tag ); ?>>
		<a itemprop="url" class="qodef-e-link-url" href="<?php echo esc_url( $link_url ); ?>" target="_blank"></a>
	</div>
<?php } ?>
