<?php
/**
 * The template to display Admin notices
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0.64
 */

$chrimson_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$chrimson_skins_args = get_query_var( 'chrimson_skins_notice_args' );
?>
<div class="chrimson_admin_notice chrimson_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$chrimson_theme_img = chrimson_get_file_url( 'screenshot.jpg' );
	if ( '' != $chrimson_theme_img ) {
		?>
		<div class="chrimson_notice_image"><img src="<?php echo esc_url( $chrimson_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'chrimson' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="chrimson_notice_title">
		<?php esc_html_e( 'New skins are available', 'chrimson' ); ?>
	</h3>
	<?php

	// Description
	$chrimson_total      = $chrimson_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$chrimson_skins_msg  = $chrimson_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $chrimson_total, 'chrimson' ), $chrimson_total ) . '</strong>'
							: '';
	$chrimson_total      = $chrimson_skins_args['free'];
	$chrimson_skins_msg .= $chrimson_total > 0
							? ( ! empty( $chrimson_skins_msg ) ? ' ' . esc_html__( 'and', 'chrimson' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $chrimson_total, 'chrimson' ), $chrimson_total ) . '</strong>'
							: '';
	$chrimson_total      = $chrimson_skins_args['pay'];
	$chrimson_skins_msg .= $chrimson_skins_args['pay'] > 0
							? ( ! empty( $chrimson_skins_msg ) ? ' ' . esc_html__( 'and', 'chrimson' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $chrimson_total, 'chrimson' ), $chrimson_total ) . '</strong>'
							: '';
	?>
	<div class="chrimson_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'chrimson' ), $chrimson_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="chrimson_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $chrimson_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'chrimson' );
			?>
		</a>
	</div>
</div>
