<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

// Page (category, tag, archive, author) title

if ( chrimson_need_page_title() ) {
	chrimson_sc_layouts_showed( 'title', true );
	chrimson_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								chrimson_show_post_meta(
									apply_filters(
										'chrimson_filter_post_meta_args', array(
											'components' => join( ',', chrimson_array_get_keys_by_value( chrimson_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', chrimson_array_get_keys_by_value( chrimson_get_theme_option( 'counters' ) ) ),
											'seo'        => chrimson_is_on( chrimson_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$chrimson_blog_title           = chrimson_get_blog_title();
							$chrimson_blog_title_text      = '';
							$chrimson_blog_title_class     = '';
							$chrimson_blog_title_link      = '';
							$chrimson_blog_title_link_text = '';
							if ( is_array( $chrimson_blog_title ) ) {
								$chrimson_blog_title_text      = $chrimson_blog_title['text'];
								$chrimson_blog_title_class     = ! empty( $chrimson_blog_title['class'] ) ? ' ' . $chrimson_blog_title['class'] : '';
								$chrimson_blog_title_link      = ! empty( $chrimson_blog_title['link'] ) ? $chrimson_blog_title['link'] : '';
								$chrimson_blog_title_link_text = ! empty( $chrimson_blog_title['link_text'] ) ? $chrimson_blog_title['link_text'] : '';
							} else {
								$chrimson_blog_title_text = $chrimson_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $chrimson_blog_title_class ); ?>">
								<?php
								$chrimson_top_icon = chrimson_get_term_image_small();
								if ( ! empty( $chrimson_top_icon ) ) {
									$chrimson_attr = chrimson_getimagesize( $chrimson_top_icon );
									?>
									<img src="<?php echo esc_url( $chrimson_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'chrimson' ); ?>"
										<?php
										if ( ! empty( $chrimson_attr[3] ) ) {
											chrimson_show_layout( $chrimson_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $chrimson_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $chrimson_blog_title_link ) && ! empty( $chrimson_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $chrimson_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $chrimson_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'chrimson_action_breadcrumbs' );
						$chrimson_breadcrumbs = ob_get_contents();
						ob_end_clean();
						chrimson_show_layout( $chrimson_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
