<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

$chrimson_args = get_query_var( 'chrimson_logo_args' );

// Site logo
$chrimson_logo_type   = isset( $chrimson_args['type'] ) ? $chrimson_args['type'] : '';
$chrimson_logo_image  = chrimson_get_logo_image( $chrimson_logo_type );
$chrimson_logo_text   = chrimson_is_on( chrimson_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$chrimson_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $chrimson_logo_image['logo'] ) || ! empty( $chrimson_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $chrimson_logo_image['logo'] ) ) {
			if ( empty( $chrimson_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($chrimson_logo_image['logo']) && (int) $chrimson_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$chrimson_attr = chrimson_getimagesize( $chrimson_logo_image['logo'] );
				echo '<img src="' . esc_url( $chrimson_logo_image['logo'] ) . '"'
						. ( ! empty( $chrimson_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $chrimson_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $chrimson_logo_text ) . '"'
						. ( ! empty( $chrimson_attr[3] ) ? ' ' . wp_kses_data( $chrimson_attr[3] ) : '' )
						. '>';
			}
		} else {
			chrimson_show_layout( chrimson_prepare_macros( $chrimson_logo_text ), '<span class="logo_text">', '</span>' );
			chrimson_show_layout( chrimson_prepare_macros( $chrimson_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
