<?php
/**
 * The template to display default site header
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

$chrimson_header_css   = '';
$chrimson_header_image = get_header_image();
$chrimson_header_video = chrimson_get_header_video();
if ( ! empty( $chrimson_header_image ) && chrimson_trx_addons_featured_image_override( is_singular() || chrimson_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$chrimson_header_image = chrimson_get_current_mode_image( $chrimson_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $chrimson_header_image ) || ! empty( $chrimson_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $chrimson_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $chrimson_header_image ) {
		echo ' ' . esc_attr( chrimson_add_inline_css_class( 'background-image: url(' . esc_url( $chrimson_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( chrimson_is_on( chrimson_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight chrimson-full-height';
	}
	$chrimson_header_scheme = chrimson_get_theme_option( 'header_scheme' );
	if ( ! empty( $chrimson_header_scheme ) && ! chrimson_is_inherit( $chrimson_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $chrimson_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $chrimson_header_video ) ) {
		get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( chrimson_is_on( chrimson_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
