<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0.10
 */

// Footer sidebar
$chrimson_footer_name    = chrimson_get_theme_option( 'footer_widgets' );
$chrimson_footer_present = ! chrimson_is_off( $chrimson_footer_name ) && is_active_sidebar( $chrimson_footer_name );
if ( $chrimson_footer_present ) {
	chrimson_storage_set( 'current_sidebar', 'footer' );
	$chrimson_footer_wide = chrimson_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $chrimson_footer_name ) ) {
		dynamic_sidebar( $chrimson_footer_name );
	}
	$chrimson_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $chrimson_out ) ) {
		$chrimson_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $chrimson_out );
		$chrimson_need_columns = true;   //or check: strpos($chrimson_out, 'columns_wrap')===false;
		if ( $chrimson_need_columns ) {
			$chrimson_columns = max( 0, (int) chrimson_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $chrimson_columns ) {
				$chrimson_columns = min( 4, max( 1, chrimson_tags_count( $chrimson_out, 'aside' ) ) );
			}
			if ( $chrimson_columns > 1 ) {
				$chrimson_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $chrimson_columns ) . ' widget', $chrimson_out );
			} else {
				$chrimson_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $chrimson_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'chrimson_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $chrimson_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $chrimson_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'chrimson_action_before_sidebar', 'footer' );
				chrimson_show_layout( $chrimson_out );
				do_action( 'chrimson_action_after_sidebar', 'footer' );
				if ( $chrimson_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $chrimson_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'chrimson_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
