<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

$chrimson_template_args = get_query_var( 'chrimson_template_args' );
if ( is_array( $chrimson_template_args ) ) {
	$chrimson_columns    = empty( $chrimson_template_args['columns'] ) ? 2 : max( 1, $chrimson_template_args['columns'] );
	$chrimson_blog_style = array( $chrimson_template_args['type'], $chrimson_columns );
    $chrimson_columns_class = chrimson_get_column_class( 1, $chrimson_columns, ! empty( $chrimson_template_args['columns_tablet']) ? $chrimson_template_args['columns_tablet'] : '', ! empty($chrimson_template_args['columns_mobile']) ? $chrimson_template_args['columns_mobile'] : '' );
} else {
	$chrimson_template_args = array();
	$chrimson_blog_style = explode( '_', chrimson_get_theme_option( 'blog_style' ) );
	$chrimson_columns    = empty( $chrimson_blog_style[1] ) ? 2 : max( 1, $chrimson_blog_style[1] );
    $chrimson_columns_class = chrimson_get_column_class( 1, $chrimson_columns );
}

$chrimson_post_format = get_post_format();
$chrimson_post_format = empty( $chrimson_post_format ) ? 'standard' : str_replace( 'post-format-', '', $chrimson_post_format );

?><div class="
<?php
if ( ! empty( $chrimson_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( chrimson_is_blog_style_use_masonry( $chrimson_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $chrimson_columns ) : esc_attr( $chrimson_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $chrimson_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $chrimson_columns )
		. ( 'portfolio' != $chrimson_blog_style[0] ? ' ' . esc_attr( $chrimson_blog_style[0] )  . '_' . esc_attr( $chrimson_columns ) : '' )
	);
	chrimson_add_blog_animation( $chrimson_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$chrimson_hover   = ! empty( $chrimson_template_args['hover'] ) && ! chrimson_is_inherit( $chrimson_template_args['hover'] )
								? $chrimson_template_args['hover']
								: chrimson_get_theme_option( 'image_hover' );

	if ( 'dots' == $chrimson_hover ) {
		$chrimson_post_link = empty( $chrimson_template_args['no_links'] )
								? ( ! empty( $chrimson_template_args['link'] )
									? $chrimson_template_args['link']
									: get_permalink()
									)
								: '';
		$chrimson_target    = ! empty( $chrimson_post_link ) && chrimson_is_external_url( $chrimson_post_link )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$chrimson_components = ! empty( $chrimson_template_args['meta_parts'] )
							? ( is_array( $chrimson_template_args['meta_parts'] )
								? $chrimson_template_args['meta_parts']
								: explode( ',', $chrimson_template_args['meta_parts'] )
								)
							: chrimson_array_get_keys_by_value( chrimson_get_theme_option( 'meta_parts' ) );

	// Featured image
	chrimson_show_post_featured( apply_filters( 'chrimson_filter_args_featured',
        array(
			'hover'         => $chrimson_hover,
			'no_links'      => ! empty( $chrimson_template_args['no_links'] ),
			'thumb_size'    => ! empty( $chrimson_template_args['thumb_size'] )
								? $chrimson_template_args['thumb_size']
								: chrimson_get_thumb_size(
									chrimson_is_blog_style_use_masonry( $chrimson_blog_style[0] )
										? (	strpos( chrimson_get_theme_option( 'body_style' ), 'full' ) !== false || $chrimson_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( chrimson_get_theme_option( 'body_style' ), 'full' ) !== false || $chrimson_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => chrimson_is_blog_style_use_masonry( $chrimson_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $chrimson_components,
			'class'         => 'dots' == $chrimson_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $chrimson_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $chrimson_post_link )
												? '<a href="' . esc_url( $chrimson_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $chrimson_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $chrimson_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $chrimson_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!