<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

$chrimson_template_args = get_query_var( 'chrimson_template_args' );

if ( is_array( $chrimson_template_args ) ) {
	$chrimson_columns    = empty( $chrimson_template_args['columns'] ) ? 2 : max( 1, $chrimson_template_args['columns'] );
	$chrimson_blog_style = array( $chrimson_template_args['type'], $chrimson_columns );
    $chrimson_columns_class = chrimson_get_column_class( 1, $chrimson_columns, ! empty( $chrimson_template_args['columns_tablet']) ? $chrimson_template_args['columns_tablet'] : '', ! empty($chrimson_template_args['columns_mobile']) ? $chrimson_template_args['columns_mobile'] : '' );
} else {
	$chrimson_template_args = array();
	$chrimson_blog_style = explode( '_', chrimson_get_theme_option( 'blog_style' ) );
	$chrimson_columns    = empty( $chrimson_blog_style[1] ) ? 2 : max( 1, $chrimson_blog_style[1] );
    $chrimson_columns_class = chrimson_get_column_class( 1, $chrimson_columns );
}
$chrimson_expanded   = ! chrimson_sidebar_present() && chrimson_get_theme_option( 'expand_content' ) == 'expand';

$chrimson_post_format = get_post_format();
$chrimson_post_format = empty( $chrimson_post_format ) ? 'standard' : str_replace( 'post-format-', '', $chrimson_post_format );

?><div class="<?php
	if ( ! empty( $chrimson_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( chrimson_is_blog_style_use_masonry( $chrimson_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $chrimson_columns ) : esc_attr( $chrimson_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $chrimson_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $chrimson_columns )
				. ' post_layout_' . esc_attr( $chrimson_blog_style[0] )
				. ' post_layout_' . esc_attr( $chrimson_blog_style[0] ) . '_' . esc_attr( $chrimson_columns )
	);
	chrimson_add_blog_animation( $chrimson_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$chrimson_hover      = ! empty( $chrimson_template_args['hover'] ) && ! chrimson_is_inherit( $chrimson_template_args['hover'] )
							? $chrimson_template_args['hover']
							: chrimson_get_theme_option( 'image_hover' );

	$chrimson_components = ! empty( $chrimson_template_args['meta_parts'] )
							? ( is_array( $chrimson_template_args['meta_parts'] )
								? $chrimson_template_args['meta_parts']
								: explode( ',', $chrimson_template_args['meta_parts'] )
								)
							: chrimson_array_get_keys_by_value( chrimson_get_theme_option( 'meta_parts' ) );

	chrimson_show_post_featured( apply_filters( 'chrimson_filter_args_featured',
		array(
			'thumb_size' => ! empty( $chrimson_template_args['thumb_size'] )
				? $chrimson_template_args['thumb_size']
				: chrimson_get_thumb_size(
					'classic' == $chrimson_blog_style[0]
						? ( strpos( chrimson_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $chrimson_columns > 2 ? 'big' : 'huge' )
								: ( $chrimson_columns > 2
									? ( $chrimson_expanded ? 'square' : 'square' )
									: ($chrimson_columns > 1 ? 'square' : ( $chrimson_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( chrimson_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $chrimson_columns > 2 ? 'masonry-big' : 'full' )
								: ($chrimson_columns === 1 ? ( $chrimson_expanded ? 'huge' : 'big' ) : ( $chrimson_columns <= 2 && $chrimson_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $chrimson_hover,
			'meta_parts' => $chrimson_components,
			'no_links'   => ! empty( $chrimson_template_args['no_links'] ),
        ),
        'content-classic',
        $chrimson_template_args
    ) );

	// Title and post meta
	$chrimson_show_title = get_the_title() != '';
	$chrimson_show_meta  = count( $chrimson_components ) > 0 && ! in_array( $chrimson_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $chrimson_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'chrimson_filter_show_blog_meta', $chrimson_show_meta, $chrimson_components, 'classic' ) ) {
				if ( count( $chrimson_components ) > 0 ) {
					do_action( 'chrimson_action_before_post_meta' );
					chrimson_show_post_meta(
						apply_filters(
							'chrimson_filter_post_meta_args', array(
							'components' => join( ',', $chrimson_components ),
							'seo'        => false,
							'echo'       => true,
						), $chrimson_blog_style[0], $chrimson_columns
						)
					);
					do_action( 'chrimson_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'chrimson_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'chrimson_action_before_post_title' );
				if ( empty( $chrimson_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'chrimson_action_after_post_title' );
			}

			if( !in_array( $chrimson_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'chrimson_filter_show_blog_readmore', ! $chrimson_show_title || ! empty( $chrimson_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $chrimson_template_args['no_links'] ) ) {
						do_action( 'chrimson_action_before_post_readmore' );
						chrimson_show_post_more_link( $chrimson_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'chrimson_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $chrimson_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('chrimson_filter_show_blog_excerpt', empty($chrimson_template_args['hide_excerpt']) && chrimson_get_theme_option('excerpt_length') > 0, 'classic')) {
			chrimson_show_post_content($chrimson_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $chrimson_template_args['more_button'] )) {
			if ( empty( $chrimson_template_args['no_links'] ) ) {
				do_action( 'chrimson_action_before_post_readmore' );
				chrimson_show_post_more_link( $chrimson_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'chrimson_action_after_post_readmore' );
			}
		}
		$chrimson_content = ob_get_contents();
		ob_end_clean();
		chrimson_show_layout($chrimson_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
