<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.71.0
 */

$chrimson_template_args = get_query_var( 'chrimson_template_args' );
if ( ! is_array( $chrimson_template_args ) ) {
	$chrimson_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$chrimson_columns       = 1;

$chrimson_expanded      = ! chrimson_sidebar_present() && chrimson_get_theme_option( 'expand_content' ) == 'expand';

$chrimson_post_format   = get_post_format();
$chrimson_post_format   = empty( $chrimson_post_format ) ? 'standard' : str_replace( 'post-format-', '', $chrimson_post_format );

if ( is_array( $chrimson_template_args ) ) {
	$chrimson_columns    = empty( $chrimson_template_args['columns'] ) ? 1 : max( 1, $chrimson_template_args['columns'] );
	$chrimson_blog_style = array( $chrimson_template_args['type'], $chrimson_columns );
	if ( ! empty( $chrimson_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $chrimson_columns > 1 ) {
	    $chrimson_columns_class = chrimson_get_column_class( 1, $chrimson_columns, ! empty( $chrimson_template_args['columns_tablet']) ? $chrimson_template_args['columns_tablet'] : '', ! empty($chrimson_template_args['columns_mobile']) ? $chrimson_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $chrimson_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $chrimson_post_format ) );
	chrimson_add_blog_animation( $chrimson_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$chrimson_hover      = ! empty( $chrimson_template_args['hover'] ) && ! chrimson_is_inherit( $chrimson_template_args['hover'] )
							? $chrimson_template_args['hover']
							: chrimson_get_theme_option( 'image_hover' );
	$chrimson_components = ! empty( $chrimson_template_args['meta_parts'] )
							? ( is_array( $chrimson_template_args['meta_parts'] )
								? $chrimson_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $chrimson_template_args['meta_parts'] ) )
								)
							: chrimson_array_get_keys_by_value( chrimson_get_theme_option( 'meta_parts' ) );
	chrimson_show_post_featured( apply_filters( 'chrimson_filter_args_featured',
		array(
			'no_links'   => ! empty( $chrimson_template_args['no_links'] ),
			'hover'      => $chrimson_hover,
			'meta_parts' => $chrimson_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $chrimson_template_args['thumb_size'] )
								? $chrimson_template_args['thumb_size']
								: chrimson_get_thumb_size( 
								in_array( $chrimson_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( chrimson_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $chrimson_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$chrimson_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$chrimson_show_title = get_the_title() != '';
		$chrimson_show_meta  = count( $chrimson_components ) > 0 && ! in_array( $chrimson_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $chrimson_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'chrimson_filter_show_blog_categories', $chrimson_show_meta && in_array( 'categories', $chrimson_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'chrimson_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						chrimson_show_post_meta( apply_filters(
															'chrimson_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $chrimson_hover, 1
															)
											);
						?>
					</div>
					<?php
					$chrimson_components = chrimson_array_delete_by_value( $chrimson_components, 'categories' );
					do_action( 'chrimson_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'chrimson_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'chrimson_action_before_post_title' );
					if ( empty( $chrimson_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'chrimson_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $chrimson_template_args['excerpt_length'] ) && ! in_array( $chrimson_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$chrimson_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'chrimson_filter_show_blog_excerpt', empty( $chrimson_template_args['hide_excerpt'] ) && chrimson_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				chrimson_show_post_content( $chrimson_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'chrimson_filter_show_blog_meta', $chrimson_show_meta, $chrimson_components, 'band' ) ) {
			if ( count( $chrimson_components ) > 0 ) {
				do_action( 'chrimson_action_before_post_meta' );
				chrimson_show_post_meta(
					apply_filters(
						'chrimson_filter_post_meta_args', array(
							'components' => join( ',', $chrimson_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'chrimson_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'chrimson_filter_show_blog_readmore', ! $chrimson_show_title || ! empty( $chrimson_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $chrimson_template_args['no_links'] ) ) {
				do_action( 'chrimson_action_before_post_readmore' );
				chrimson_show_post_more_link( $chrimson_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'chrimson_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $chrimson_template_args ) ) {
	if ( ! empty( $chrimson_template_args['slider'] ) || $chrimson_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
